$(function(){

    $('#aux_start_date').add('#aux_end_date').datepicker({
        dateFormat: 'dd/mm/yy',
        showOn: 'both',
        buttonImage: '/images/cal.png',
        buttonImageOnly: true
    });

    $('#aux_start_time').timepickr({
        handle: '#trigger-start-time',
        rangeMin: ['00', '05', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55']

    });
    $('#aux_end_time').timepickr({
        handle: '#trigger-end-time',
        rangeMin: ['00', '05', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55']
    });

    $('#unavailability_form').submit(function(){

        var arrival_time = $.trim($('#aux_start_time').val());
        if (arrival_time.match(/(\d{1,2}):(\d{2}) (am|pm)/)){
            
            arrival_time = arrival_time.split(' ');
            var arrival_hour_minute = arrival_time[0].split(':');
            var arrival_am_pm = arrival_time[1];
            var arrival_hour = arrival_hour_minute[0];
            var arrival_minute = arrival_hour_minute[1];
            
            arrival_hour = arrival_am_pm=='pm'?(parseInt(arrival_hour)+12)%24:arrival_hour;
            var auxDate = $('#aux_start_date').val().split('/');

            $('#start_date').val( auxDate[2] + '/' + auxDate[1] + '/' + auxDate[0] + ' ' + arrival_hour+':'+arrival_minute+':00');
        }
        
        var departure_time = $.trim($('#aux_end_time').val());
        if (departure_time.match(/(\d{1,2}):(\d{2}) (am|pm)/)){
            departure_time = departure_time.split(' ');
            var departure_hour_minute = departure_time[0].split(':');
            var departure_am_pm = departure_time[1];
            var departure_hour = departure_hour_minute[0];
            var departure_minute = departure_hour_minute[1];

            departure_hour = departure_am_pm=='pm'?(parseInt(departure_hour)+12)%24:departure_hour;
            auxDate = $('#aux_end_date').val().split('/');
            
            $('#end_date').val( auxDate[2] + '/' + auxDate[1] + '/' + auxDate[0] +' '+departure_hour+':'+departure_minute+':00');
        }


    });

    if($('#start_date').val().length==19){
        var arrDT = $('#start_date').val().split(' ');
        var uDate = arrDT[0];
        var uArrayDate = uDate.split('/');
        var uDay = uArrayDate[2];
        var uMonth = uArrayDate[1];
        var uYear = uArrayDate[0];
        var uHour = arrDT[1];
        var arrH = uHour.split(':');
        var uH = arrH[0];
        var uM = arrH[1];
        var uAPM = arrH[0]<=12?'am':'pm';
        $('#aux_start_date').val(uDay + '/' +uMonth + '/' +uYear);
        $('#aux_start_time').val( (uH%12)+':' + uM + ' ' + uAPM );
    }

    if($('#end_date').val().length==19){
        arrDT = $('#end_date').val().split(' ');
        uDate = arrDT[0];
        uArrayDate = uDate.split('/');
        uDay = uArrayDate[2];
        uMonth = uArrayDate[1];
        uYear = uArrayDate[0];
        uHour = arrDT[1];
        arrH = uHour.split(':');
        uH = arrH[0];
        uM = arrH[1];
        uAPM = arrH[0]<=12?'am':'pm';
        $('#aux_end_date').val(uDay + '/' +uMonth + '/' +uYear);
        $('#aux_end_time').val( (uH%12)+':' + uM + ' ' + uAPM );
    }

});
