
var autocomplete_options = {
    max: 100,
    width: 200,
    formatItem: function(data, i, total){
        return data[0] + "(" + data[2] + ")";
    },
    formatResult: function(data){
        return data[0];
    }
};


var auto_doc = function(event, data, formatted) {
    // fill the name
    $(this).parent().next().next().find('input:first').val(data[2]);
    // fill the weight
    $(this).parent().next().next().next().find('input:first').val(data[3]);
    // fill the doc type
    $(this).parent().next().find('option').attr("selected", false);
    $(this).parent().next().find("option[value="+data[1]+"]").attr("selected", true);	
    // fill the company
    $(this).parent().next().next().next().next().next().find('option').attr("selected", false);
    $(this).parent().next().next().next().next().next().find("option[value="+data[4]+"]").attr("selected", true);	
}

function add_forms(sender, count_input, form, form_name, form_blocks){
    // get the formset table	
    var table = sender.parent().prev();
    form_name = form_name.substring(0, form_name.indexOf('#') + 1); 
    // insert the empty forms in blocks of size @form_blocks
    for (i=0; i<form_blocks; i++) {
        $(form).find('.auto-doc, .auto-doc-pass').autocomplete(autocomplete_endpoint, autocomplete_options).result(auto_doc).end().appendTo(table);
        //table.append(form);
        form_iterator = i + parseInt(count_input.val());

        table.find('tr:last input').each(function(){
            var current_name = $(this).attr("name");
            current_name = current_name.substring(
            current_name.indexOf('['));
            $(this).attr("name", form_name + form_iterator + current_name);
        });

        table.find('tr:last select').each(function(){
            var current_name = $(this).attr("name");
            current_name = current_name.substring(
            current_name.indexOf('['));
            $(this).attr("name", form_name + form_iterator + current_name);
        });

        if (form_iterator % 2 == 0){
            table.find('tr:last').attr("class", "odd");
        }

    }
    // update the form count
    count_input.val(parseInt(count_input.val()) + form_blocks);
}

function resetEmptyForms(){

    $('.cVal input').each(function(){
        $(this).removeAttr('value');
    });
    
    $('.cSel select option').each(function(){
        $(this).removeAttr('selected');
    });
    
    $('.cChk input').each(function(){
        $(this).removeAttr('checked');
    });

}

$(document).ready(function(){

    resetEmptyForms();

    var form_blocks = 5;
    $("#more-crew").click(function(){
        // get the form counter
        var count_input = $("input[name=crew_max_forms]");
        // get the the empty form code
        var form_code = $("#crew-empty-form").html();
        // prepare the name for the forms (just the prefix)
        var form_name = $("#crew-empty-form input:first").attr("name");
        // finally add the forms
        add_forms($(this), count_input, form_code, form_name, form_blocks);
        return false;
    });

    $("#more-passengers").click(function(){
        // get the form counter
        var count_input = $("input[name=passengers_max_forms]");
        // get the the empty form code
	var form_code = $("#passenger-empty-form").html();
        // prepare the name for the forms (just the prefix)
        var form_name = $("#passenger-empty-form input:first").attr("name");
        // finally add the forms
        add_forms($(this), count_input, form_code, form_name, form_blocks);
        return false;
    });

    $("#more-cargo").click(function(){
        // get the form counter
        var count_input = $("input[name=cargo_max_forms]");
        // get the the empty form code
        var form_code = $("#cargo-empty-form").html();
        // prepare the name for the forms (just the prefix)
        var form_name = $("#cargo-empty-form input:first").attr("name");
        // finally add the forms
        add_forms($(this), count_input, form_code, form_name, form_blocks);
        return false;
    });

    // add autocomplete functionalty for crew
    $(".auto-doc").autocomplete(autocomplete_endpoint, autocomplete_options);
    $(".auto-doc").result(auto_doc);
    // add autocomplete functionalty for crew passengers
    $(".auto-doc-pass").autocomplete(autocomplete_endpoint,

    autocomplete_options

    /*{
        max: 100,
        width: 200,
        formatItem: function(data, i, total){
            return data[0] + "(" + data[2] + ")";
        },
        formatResult: function(data){
            return data[0];
        }
    }*/
    
    );

    
    $(".auto-doc-pass").result(function(event, data, formatted) {
        // fill the name
        $(this).parent().next().next().find('input:first').val(data[2]);
        // fill the weight
        $(this).parent().next().next().next().next().find('input:first').val(data[3]);
        // fill the doc type
        $(this).parent().next().find('option').attr("selected", false);
        $(this).parent().next().find("option[value="+data[1]+"]").attr("selected", true);
        // fill the company
        $(this).parent().next().next().next().find('option').attr("selected", false);
        $(this).parent().next().next().next().find("option[value="+data[4]+"]").attr("selected", true);
        // fill the cost center
        $(this).parent().next().next().next().next().next().find('option').attr("selected", false);
        $(this).parent().next().next().next().next().next().find("option[value="+data[5]+"]").attr("selected", true);

    });

});
