import MySQLdb

# open databases
old_db = MySQLdb.connect(host="localhost", user="root", db="BDPerenco")
new_db = MySQLdb.connect(host="localhost", user="root", db="perenco_prod")
old_cursor = old_db.cursor()
new_cursor = new_db.cursor()


# migrate lugares into location
print "Reading lugares table (old)"
old_cursor.execute("SELECT nom_lugar FROM lugares")
results = old_cursor.fetchall()
for row in results:
    new_cursor.execute("INSERT INTO location (short_name, name) values"
                       "('%s','%s')" % (row[0][:3], row[0]))
print "Imported %s rows" % len(results)

# migrate lugaresd into distance
print "Reading lugaresd table (old)"
old_cursor.execute("SELECT origen, destino, distancia FROM lugaresd ")
results = old_cursor.fetchall()
for row in results:
    try:
        # get origin and destiny id
        cursor = new_db.cursor()
        cursor.execute("SELECT id FROM location WHERE name = '%s'" % row[0] )
        origin_id = cursor.fetchone()

        cursor.execute("SELECT id FROM location WHERE name = '%s'" % row[1] )
        destination_id = cursor.fetchone()

        # some distances doesn't have related rows so add them
        if origin_id is None:
            new_cursor.execute("INSERT INTO location (short_name, name) values"
                               "('%s','%s')" % (row[0][:3], row[0]))
            cursor.execute("SELECT id FROM location WHERE name = '%s'" % row[0] )
            origin_id = cursor.fetchone()

        if destination_id is None:
            new_cursor.execute("INSERT INTO location (short_name, name) values"
                                   "('%s','%s')" % (row[1][:3], row[1]))
            cursor.execute("SELECT id FROM location WHERE name = '%s'" % row[1] )
            destination_id = cursor.fetchone()
        
        distance  =  row[2]
        if distance is None:
            distance = 0
        new_cursor.execute("INSERT INTO distance (origin_id, destination_id," 
                           "distance) values (%s, %s, '%s')" %\
                               (origin_id[0], destination_id[0], distance))
    except:
        print "Duplicated entry :%s" % row[0]

print "Imported %s rows" % len(results)


# migrate empresas into company
print "Reading empresas table (old)"
old_cursor.execute("SELECT razon_emp, ruc_emp FROM empresas")
results = old_cursor.fetchall()
for row in results:
    try:
        new_cursor.execute("INSERT INTO company (name, ruc) values"
                           "('%s','%s')" % (row[0][:11], row[1][:255]))
    except:
        print "Duplicate ruc: %s" % row[1]
 
print "Imported %s rows" % len(results)


# migrate table centro_costo into cost_center
print "Reading centro_costo table (old)"
old_cursor.execute("SELECT nombre FROM centro_costo")
results = old_cursor.fetchall()
for row in results:
    try:
        new_cursor.execute("INSERT INTO cost_center (name) values"
                           "('%s')" % (row[0][:128]))
    except:
        print "Duplicated entry: %s" % row[0]
 
print "Imported %s rows" % len(results)

# migrate table transporte into vehicle
print "Reading transporte table (old)"
old_cursor.execute("SELECT mat_trans, tipo_trans, model_trans, cappass_trans, costo_mov, costo_desmov  FROM transporte")
results = old_cursor.fetchall()
for row in results:
    category = 'Fluvial'
    if row[1] == 'HELICOPTERO':
        category = 'Aereo'
    cmov = row[4]
    cdmov = row[5]
    if cmov is None:
        cmov = '0'
    if cdmov is None:
        cdmov =  '0'

    try:
        sql = "INSERT INTO vehicle (plate, category, model_name, max_passengers, hard_weight_limit, safe_weight_limit, monthly_cost, per_trip_cost, min_hours, hourly_fuel_consumption, contract_type, mobilization_cost, demobilization_cost, stepped_hourly_rates, company_id) values ('%s', '%s', '%s', %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)" % (row[0][:128], category, row[2], row[3], 0, 0, 0, 0, 0, 0, "'Encendido/Apagado'",  cmov, cdmov, 0, 1)
        new_cursor.execute(sql)
    except:
        print "Duplicated entry: %s" % row[0]
        
print "Imported %s rows" % len(results)


# migrate table cargo_per into  job
print "Reading cargo_per table (old)"
old_cursor.execute("SELECT nombre FROM cargo_per")
results = old_cursor.fetchall()
for row in results:
    try:
        new_cursor.execute("INSERT INTO job (name) values"
                           "('%s')" % (row[0][:64]))
    except:
        print "Duplicated entry: %s" % row[0]
 
print "Imported %s rows" % len(results)


# migrate table personal into  person
print "Reading personal table (old)"
old_cursor.execute("SELECT p.tipodoc, p.dociden_per, p.nom_per, concat(concat(p.appat_per, ' '), p.apmat_per), p.peso_per, e.ruc_emp, p.cargo_per, centrocosto    FROM personal p JOIN empresas e ON (e.cod_emp=p.cod_emp)")
results = old_cursor.fetchall()
for row in results:
    doc_type = row[0]
    if doc_type == 'CARNET EXTRANJ.':
        doc_type = 'CE'

    # get the related company id
    cursor = new_db.cursor()
    cursor.execute("SELECT id FROM company WHERE ruc = '%s'" % row[5] )
    try:
        company_id = cursor.fetchone()[0]
    except TypeError:
        print "Company not found"
        break
        
    # get the related job id
    try:
        cursor = new_db.cursor()
        cursor.execute("SELECT id FROM job WHERE name = '%s'" % row[6] )
        job_id = cursor.fetchone()[0]
    except TypeError:
        print "Job not found, creating one"
        cursor = new_db.cursor()
        cursor.execute("INSERT INTO job (name) values ('%s')" % row[6] )
        cursor.execute("SELECT id FROM job WHERE name = '%s'" % row[6] )
        job_id = cursor.fetchone()[0]

        
    # get the related cost_center
    try:
        cursor = new_db.cursor()
        cursor.execute("SELECT id FROM cost_center WHERE name = '%s'" % row[7] )
        cc_id = cursor.fetchone()[0]
    except TypeError:
        print "Cost Center not found, creating one"
        cursor = new_db.cursor()
        cursor.execute("INSERT INTO cost_center (name) values ('%s')" % row[7])
        cursor.execute("SELECT id FROM cost_center WHERE name = '%s'" % row[7] )
        cc_id = cursor.fetchone()[0]



    sql = "INSERT INTO person (doc_type, doc_number, firstname, last_name, weight, company_id, job_id, cost_center_id) values ('%s', '%s', '%s', '%s', %s, %s, %s, %s )" % (doc_type, row[1], row[2], row[3], row[4], company_id, job_id, cc_id)
    new_cursor.execute(sql)
    #print "Duplicated entry: %s" % row[0]
 
print "Imported %s rows" % len(results)



# migrate table ruta into  trip
print "Reading ruta table (old)"
old_cursor.execute("SELECT r.mat_trans, r.orig_ruta, r.dest_ruta, r.fecha_ruta, r.horasal_ruta, r.horallega_ruta, r.testimado_ruta, r.combustible, d.ini, d.obser, d.fechasalida, d.fechallegada, r.via FROM ruta r JOIN ruta_det d ON (r.cod_ruta=d.cod_ruta)")
results = old_cursor.fetchall()
for row in results:
    # get related vehicle
    try:
        cursor = new_db.cursor()
        cursor.execute("SELECT id FROM vehicle WHERE plate = '%s'" % row[0])
        vehicle_id = cursor.fetchone()[0]
    except TypeError:
        # not enough information for creating a new vehicle
        print "Vehicle not found"
        break


    #get the related origin
    try:
        cursor = new_db.cursor()
        cursor.execute("SELECT id FROM location WHERE name = '%s'" % row[8])
        origin_id = cursor.fetchone()[0]
    except TypeError:
        print "Location not found"
        cursor.execute("INSERT INTO location (name) values ('%s')" % row[8])
        cursor.execute("SELECT id FROM location WHERE name = '%s'" % row[8])
        origin_id = cursor.fetchone()[0]
        
    departure_date = row[4] or row[10]
    arrival_date = row[5] or row[11]
    description = row[9]
    estimated_departure = row[10]
    estimated_arrival = row[11]
    via = row[12]
    if via == 'A':
        via = 'Aereo'
    else:
        via = 'Fluvial'
    cost = row[7]
    
    sql = "INSERT INTO trip (vehicle_id, origin_id, departure_date, arrival_date, description, notes, estimated_departure, estimated_duration, type, cost) values (%s, %s, '%s', '%s', '%s', '%s', '%s', %s, '%s', %s)" % (vehicle_id, origin_id, departure_date, arrival_date, description, '', estimated_departure, 2, via, cost)
    try:
        new_cursor.execute(sql)
    except:
        pass
    # get the last trip inserted
    cursor.execute("SELECT max(id) from trip")
    trip_id = cursor.fetchone()[0]

#    sql_stretch = "INSERT INTO stretch (vehicle_id, origin_id, departure_date, arrival_date, description, notes, estimated_departure, estimated_duration, type, cost) values (%s, %s, '%s', '%s', '%s', '%s', '%s', %s, '%s', %s)" % (vehicle_id, origin_id, departure_date, arrival_date, description, '', estimated_departure, 2, via, cost)



 
print "Imported %s rows" % len(results)



# commit and close connection
old_cursor.close()
new_cursor.close()
old_db.commit()
new_db.commit()
old_db.close()
new_db.close()
