<?php

class baseQueriesTask extends sfBaseTask
{
  protected function configure()
  {
    // // add your own arguments here
    // $this->addArguments(array(
    //   new sfCommandArgument('my_arg', sfCommandArgument::REQUIRED, 'My argument'),
    // ));

    $this->addOptions(array(
      new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
      new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
      new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'doctrine'),
      // add your own options here
    ));

    $this->namespace        = 'doctrinepractice';
    $this->name             = 'baseQueries';
    $this->briefDescription = 'Doctrine practice queries with the project schema';
    $this->detailedDescription = <<<EOF
The [baseQueries|INFO] task does things.
Call it with:

  [php symfony baseQueries|INFO]
EOF;
  }

  protected function execute($arguments = array(), $options = array())
  {
    // initialize the database connection
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager
      ->getDatabase($options['connection'] ? $options['connection'] : null)
      ->getConnection();

    // add your code here
    print "\n Retrieve all the passangers and loads of a flight (stretch) \n ";
    /* get the stretch with id 1 */
    $stretch = Doctrine::getTable('Stretch')
      ->find(array(1));
    /* get all the related passangers */
    foreach ($stretch->PassangerManifestDetails as $detail){
      print $detail->Passanger['name'];      
    }
    /* get all the related loads */
    foreach ($stretch->LoadManifestDetails as $detail){
      print $detail['code'];      
    }

    print "\n Retrieve all the passangers flights between two given dates \n ";
    $date1 = '2008-01-23';
    $date2 = '2009-01-23';  
    $passanger = Doctrine::getTable('Passanger')
      ->find(array(1));
    /* get flights related with the passanger and in the desired date range */
    $flights = Doctrine_Query::create()
      ->select('s.id')
      ->from('Stretch s')
      ->leftJoin('s.PassangerManifestDetails pd')
      ->where('pd.passanger_id = ?', $passanger['id'])
      ->andWhere('s.arrival_time >= ?', $date1)
      ->andWhere('s.arrival_time <= ?', $date2)
      ->fetchArray();
    print_r($flights);
  }
}
