<?php

/**
 * BaseVehicle
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $company_id
 * @property string $plate
 * @property enum $category
 * @property string $model_name
 * @property integer $hard_weight_limit
 * @property integer $safe_weight_limit
 * @property integer $max_passengers
 * @property decimal $monthly_cost
 * @property decimal $per_trip_cost
 * @property integer $min_hours
 * @property decimal $hourly_fuel_consumption
 * @property enum $contract_type
 * @property decimal $mobilization_cost
 * @property decimal $demobilization_cost
 * @property text $stepped_hourly_rates
 * @property integer $month_billable_time
 * @property boolean $is_active
 * @property Company $Company
 * @property Doctrine_Collection $Trips
 * @property Doctrine_Collection $VechileUnavailabilities
 * 
 * @method integer             getCompanyId()               Returns the current record's "company_id" value
 * @method string              getPlate()                   Returns the current record's "plate" value
 * @method enum                getCategory()                Returns the current record's "category" value
 * @method string              getModelName()               Returns the current record's "model_name" value
 * @method integer             getHardWeightLimit()         Returns the current record's "hard_weight_limit" value
 * @method integer             getSafeWeightLimit()         Returns the current record's "safe_weight_limit" value
 * @method integer             getMaxPassengers()           Returns the current record's "max_passengers" value
 * @method decimal             getMonthlyCost()             Returns the current record's "monthly_cost" value
 * @method decimal             getPerTripCost()             Returns the current record's "per_trip_cost" value
 * @method integer             getMinHours()                Returns the current record's "min_hours" value
 * @method decimal             getHourlyFuelConsumption()   Returns the current record's "hourly_fuel_consumption" value
 * @method enum                getContractType()            Returns the current record's "contract_type" value
 * @method decimal             getMobilizationCost()        Returns the current record's "mobilization_cost" value
 * @method decimal             getDemobilizationCost()      Returns the current record's "demobilization_cost" value
 * @method text                getSteppedHourlyRates()      Returns the current record's "stepped_hourly_rates" value
 * @method integer             getMonthBillableTime()       Returns the current record's "month_billable_time" value
 * @method boolean             getIsActive()                Returns the current record's "is_active" value
 * @method Company             getCompany()                 Returns the current record's "Company" value
 * @method Doctrine_Collection getTrips()                   Returns the current record's "Trips" collection
 * @method Doctrine_Collection getVechileUnavailabilities() Returns the current record's "VechileUnavailabilities" collection
 * @method Vehicle             setCompanyId()               Sets the current record's "company_id" value
 * @method Vehicle             setPlate()                   Sets the current record's "plate" value
 * @method Vehicle             setCategory()                Sets the current record's "category" value
 * @method Vehicle             setModelName()               Sets the current record's "model_name" value
 * @method Vehicle             setHardWeightLimit()         Sets the current record's "hard_weight_limit" value
 * @method Vehicle             setSafeWeightLimit()         Sets the current record's "safe_weight_limit" value
 * @method Vehicle             setMaxPassengers()           Sets the current record's "max_passengers" value
 * @method Vehicle             setMonthlyCost()             Sets the current record's "monthly_cost" value
 * @method Vehicle             setPerTripCost()             Sets the current record's "per_trip_cost" value
 * @method Vehicle             setMinHours()                Sets the current record's "min_hours" value
 * @method Vehicle             setHourlyFuelConsumption()   Sets the current record's "hourly_fuel_consumption" value
 * @method Vehicle             setContractType()            Sets the current record's "contract_type" value
 * @method Vehicle             setMobilizationCost()        Sets the current record's "mobilization_cost" value
 * @method Vehicle             setDemobilizationCost()      Sets the current record's "demobilization_cost" value
 * @method Vehicle             setSteppedHourlyRates()      Sets the current record's "stepped_hourly_rates" value
 * @method Vehicle             setMonthBillableTime()       Sets the current record's "month_billable_time" value
 * @method Vehicle             setIsActive()                Sets the current record's "is_active" value
 * @method Vehicle             setCompany()                 Sets the current record's "Company" value
 * @method Vehicle             setTrips()                   Sets the current record's "Trips" collection
 * @method Vehicle             setVechileUnavailabilities() Sets the current record's "VechileUnavailabilities" collection
 * 
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BaseVehicle extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('vehicle');
        $this->hasColumn('company_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('plate', 'string', 20, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '20',
             ));
        $this->hasColumn('category', 'enum', null, array(
             'type' => 'enum',
             'values' => 
             array(
              0 => 'Aereo',
              1 => 'Fluvial',
             ),
             'notnull' => true,
             ));
        $this->hasColumn('model_name', 'string', 50, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '50',
             ));
        $this->hasColumn('hard_weight_limit', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('safe_weight_limit', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('max_passengers', 'integer', null, array(
             'type' => 'integer',
             'notnull' => false,
             ));
        $this->hasColumn('monthly_cost', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => true,
             'default' => 0,
             ));
        $this->hasColumn('per_trip_cost', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => false,
             'default' => 0,
             ));
        $this->hasColumn('min_hours', 'integer', null, array(
             'type' => 'integer',
             'notnull' => false,
             ));
        $this->hasColumn('hourly_fuel_consumption', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => true,
             'default' => 0,
             ));
        $this->hasColumn('contract_type', 'enum', null, array(
             'type' => 'enum',
             'values' => 
             array(
              0 => 'Encendido/Apagado',
              1 => 'Tiempo en el Aire',
             ),
             'notnull' => true,
             'default' => 'Encendido/Apagado',
             ));
        $this->hasColumn('mobilization_cost', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => false,
             ));
        $this->hasColumn('demobilization_cost', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => false,
             ));
        $this->hasColumn('stepped_hourly_rates', 'text', null, array(
             'type' => 'text',
             'notnull' => false,
             ));
        $this->hasColumn('month_billable_time', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             'default' => 0,
             ));
        $this->hasColumn('is_active', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             'default' => 1,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Company', array(
             'local' => 'company_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasMany('Trip as Trips', array(
             'local' => 'id',
             'foreign' => 'vehicle_id'));

        $this->hasMany('VehicleUnavailability as VechileUnavailabilities', array(
             'local' => 'id',
             'foreign' => 'vehicle_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}