<?php

/**
 * BaseStretchManifestDetail
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $stretch_id
 * @property integer $passenger_manifest_detail_id
 * @property integer $cargo_manifest_detail_id
 * @property enum $type
 * @property decimal $weight_x_distance
 * @property decimal $minutes
 * @property decimal $monetary_value
 * @property Stretch $Stretch
 * @property PassengerManifestDetail $PassengerManifestDetail
 * @property CargoManifestDetail $CargoManifestDetail
 * 
 * @method integer                 getStretchId()                    Returns the current record's "stretch_id" value
 * @method integer                 getPassengerManifestDetailId()    Returns the current record's "passenger_manifest_detail_id" value
 * @method integer                 getCargoManifestDetailId()        Returns the current record's "cargo_manifest_detail_id" value
 * @method enum                    getType()                         Returns the current record's "type" value
 * @method decimal                 getWeightXDistance()              Returns the current record's "weight_x_distance" value
 * @method decimal                 getMinutes()                      Returns the current record's "minutes" value
 * @method decimal                 getMonetaryValue()                Returns the current record's "monetary_value" value
 * @method Stretch                 getStretch()                      Returns the current record's "Stretch" value
 * @method PassengerManifestDetail getPassengerManifestDetail()      Returns the current record's "PassengerManifestDetail" value
 * @method CargoManifestDetail     getCargoManifestDetail()          Returns the current record's "CargoManifestDetail" value
 * @method StretchManifestDetail   setStretchId()                    Sets the current record's "stretch_id" value
 * @method StretchManifestDetail   setPassengerManifestDetailId()    Sets the current record's "passenger_manifest_detail_id" value
 * @method StretchManifestDetail   setCargoManifestDetailId()        Sets the current record's "cargo_manifest_detail_id" value
 * @method StretchManifestDetail   setType()                         Sets the current record's "type" value
 * @method StretchManifestDetail   setWeightXDistance()              Sets the current record's "weight_x_distance" value
 * @method StretchManifestDetail   setMinutes()                      Sets the current record's "minutes" value
 * @method StretchManifestDetail   setMonetaryValue()                Sets the current record's "monetary_value" value
 * @method StretchManifestDetail   setStretch()                      Sets the current record's "Stretch" value
 * @method StretchManifestDetail   setPassengerManifestDetail()      Sets the current record's "PassengerManifestDetail" value
 * @method StretchManifestDetail   setCargoManifestDetail()          Sets the current record's "CargoManifestDetail" value
 * 
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BaseStretchManifestDetail extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('stretch_manifest_detail');
        $this->hasColumn('stretch_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('passenger_manifest_detail_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('cargo_manifest_detail_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('type', 'enum', null, array(
             'type' => 'enum',
             'values' => 
             array(
              0 => 'passenger',
              1 => 'cargo',
             ),
             'notnull' => true,
             ));
        $this->hasColumn('weight_x_distance', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => true,
             'default' => 0,
             ));
        $this->hasColumn('minutes', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => true,
             'default' => 0,
             ));
        $this->hasColumn('monetary_value', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => true,
             'default' => 0,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Stretch', array(
             'local' => 'stretch_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('PassengerManifestDetail', array(
             'local' => 'passenger_manifest_detail_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('CargoManifestDetail', array(
             'local' => 'cargo_manifest_detail_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));
    }
}