<?php

/**
 * BaseStretch
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $trip_id
 * @property integer $origin_id
 * @property integer $destination_id
 * @property string $description
 * @property timestamp $engine_start_time
 * @property timestamp $takeoff_time
 * @property timestamp $departure_time
 * @property timestamp $arrival_time
 * @property timestamp $landing_time
 * @property timestamp $engine_stop_time
 * @property decimal $cargo_weight
 * @property decimal $passenger_weight
 * @property integer $passenger_count
 * @property boolean $fuel_recharge
 * @property enum $load_type
 * @property decimal $billable_gallons
 * @property decimal $non_billable_gallons
 * @property decimal $iquitos_gallons
 * @property decimal $billable_time
 * @property integer $initial_billable_time
 * @property integer $assigned_billable_time
 * @property timestamp $starting_time
 * @property timestamp $stopping_time
 * @property Trip $Trip
 * @property Location $Origin
 * @property Location $Destination
 * @property Doctrine_Collection $Copy
 * @property Doctrine_Collection $ManifestDetails
 * @property Doctrine_Collection $PassengerManifestDetailsAsOrigin
 * @property Doctrine_Collection $PassengerManifestDetailsAsDestination
 * @property Doctrine_Collection $CargoManifestDetailsAsOrigin
 * @property Doctrine_Collection $CargoManifestDetailsAsDestination
 * 
 * @method integer             getTripId()                                Returns the current record's "trip_id" value
 * @method integer             getOriginId()                              Returns the current record's "origin_id" value
 * @method integer             getDestinationId()                         Returns the current record's "destination_id" value
 * @method string              getDescription()                           Returns the current record's "description" value
 * @method timestamp           getEngineStartTime()                       Returns the current record's "engine_start_time" value
 * @method timestamp           getTakeoffTime()                           Returns the current record's "takeoff_time" value
 * @method timestamp           getDepartureTime()                         Returns the current record's "departure_time" value
 * @method timestamp           getArrivalTime()                           Returns the current record's "arrival_time" value
 * @method timestamp           getLandingTime()                           Returns the current record's "landing_time" value
 * @method timestamp           getEngineStopTime()                        Returns the current record's "engine_stop_time" value
 * @method decimal             getCargoWeight()                           Returns the current record's "cargo_weight" value
 * @method decimal             getPassengerWeight()                       Returns the current record's "passenger_weight" value
 * @method integer             getPassengerCount()                        Returns the current record's "passenger_count" value
 * @method boolean             getFuelRecharge()                          Returns the current record's "fuel_recharge" value
 * @method enum                getLoadType()                              Returns the current record's "load_type" value
 * @method decimal             getBillableGallons()                       Returns the current record's "billable_gallons" value
 * @method decimal             getNonBillableGallons()                    Returns the current record's "non_billable_gallons" value
 * @method decimal             getIquitosGallons()                        Returns the current record's "iquitos_gallons" value
 * @method decimal             getBillableTime()                          Returns the current record's "billable_time" value
 * @method integer             getInitialBillableTime()                   Returns the current record's "initial_billable_time" value
 * @method integer             getAssignedBillableTime()                  Returns the current record's "assigned_billable_time" value
 * @method timestamp           getStartingTime()                          Returns the current record's "starting_time" value
 * @method timestamp           getStoppingTime()                          Returns the current record's "stopping_time" value
 * @method Trip                getTrip()                                  Returns the current record's "Trip" value
 * @method Location            getOrigin()                                Returns the current record's "Origin" value
 * @method Location            getDestination()                           Returns the current record's "Destination" value
 * @method Doctrine_Collection getCopy()                                  Returns the current record's "Copy" collection
 * @method Doctrine_Collection getManifestDetails()                       Returns the current record's "ManifestDetails" collection
 * @method Doctrine_Collection getPassengerManifestDetailsAsOrigin()      Returns the current record's "PassengerManifestDetailsAsOrigin" collection
 * @method Doctrine_Collection getPassengerManifestDetailsAsDestination() Returns the current record's "PassengerManifestDetailsAsDestination" collection
 * @method Doctrine_Collection getCargoManifestDetailsAsOrigin()          Returns the current record's "CargoManifestDetailsAsOrigin" collection
 * @method Doctrine_Collection getCargoManifestDetailsAsDestination()     Returns the current record's "CargoManifestDetailsAsDestination" collection
 * @method Stretch             setTripId()                                Sets the current record's "trip_id" value
 * @method Stretch             setOriginId()                              Sets the current record's "origin_id" value
 * @method Stretch             setDestinationId()                         Sets the current record's "destination_id" value
 * @method Stretch             setDescription()                           Sets the current record's "description" value
 * @method Stretch             setEngineStartTime()                       Sets the current record's "engine_start_time" value
 * @method Stretch             setTakeoffTime()                           Sets the current record's "takeoff_time" value
 * @method Stretch             setDepartureTime()                         Sets the current record's "departure_time" value
 * @method Stretch             setArrivalTime()                           Sets the current record's "arrival_time" value
 * @method Stretch             setLandingTime()                           Sets the current record's "landing_time" value
 * @method Stretch             setEngineStopTime()                        Sets the current record's "engine_stop_time" value
 * @method Stretch             setCargoWeight()                           Sets the current record's "cargo_weight" value
 * @method Stretch             setPassengerWeight()                       Sets the current record's "passenger_weight" value
 * @method Stretch             setPassengerCount()                        Sets the current record's "passenger_count" value
 * @method Stretch             setFuelRecharge()                          Sets the current record's "fuel_recharge" value
 * @method Stretch             setLoadType()                              Sets the current record's "load_type" value
 * @method Stretch             setBillableGallons()                       Sets the current record's "billable_gallons" value
 * @method Stretch             setNonBillableGallons()                    Sets the current record's "non_billable_gallons" value
 * @method Stretch             setIquitosGallons()                        Sets the current record's "iquitos_gallons" value
 * @method Stretch             setBillableTime()                          Sets the current record's "billable_time" value
 * @method Stretch             setInitialBillableTime()                   Sets the current record's "initial_billable_time" value
 * @method Stretch             setAssignedBillableTime()                  Sets the current record's "assigned_billable_time" value
 * @method Stretch             setStartingTime()                          Sets the current record's "starting_time" value
 * @method Stretch             setStoppingTime()                          Sets the current record's "stopping_time" value
 * @method Stretch             setTrip()                                  Sets the current record's "Trip" value
 * @method Stretch             setOrigin()                                Sets the current record's "Origin" value
 * @method Stretch             setDestination()                           Sets the current record's "Destination" value
 * @method Stretch             setCopy()                                  Sets the current record's "Copy" collection
 * @method Stretch             setManifestDetails()                       Sets the current record's "ManifestDetails" collection
 * @method Stretch             setPassengerManifestDetailsAsOrigin()      Sets the current record's "PassengerManifestDetailsAsOrigin" collection
 * @method Stretch             setPassengerManifestDetailsAsDestination() Sets the current record's "PassengerManifestDetailsAsDestination" collection
 * @method Stretch             setCargoManifestDetailsAsOrigin()          Sets the current record's "CargoManifestDetailsAsOrigin" collection
 * @method Stretch             setCargoManifestDetailsAsDestination()     Sets the current record's "CargoManifestDetailsAsDestination" collection
 * 
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BaseStretch extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('stretch');
        $this->hasColumn('trip_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('origin_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('destination_id', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('description', 'string', 200, array(
             'type' => 'string',
             'length' => '200',
             ));
        $this->hasColumn('engine_start_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => false,
             ));
        $this->hasColumn('takeoff_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => false,
             ));
        $this->hasColumn('departure_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => false,
             ));
        $this->hasColumn('arrival_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => false,
             ));
        $this->hasColumn('landing_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => false,
             ));
        $this->hasColumn('engine_stop_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => false,
             ));
        $this->hasColumn('cargo_weight', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => false,
             ));
        $this->hasColumn('passenger_weight', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => false,
             ));
        $this->hasColumn('passenger_count', 'integer', null, array(
             'type' => 'integer',
             'default' => 0,
             ));
        $this->hasColumn('fuel_recharge', 'boolean', null, array(
             'type' => 'boolean',
             'default' => false,
             ));
        $this->hasColumn('load_type', 'enum', null, array(
             'type' => 'enum',
             'values' => 
             array(
              0 => 'Carga externa',
              1 => 'Carga interna',
              2 => 'Pasajeros',
              3 => 'Carga interna y pasajeros',
              4 => 'Materiales de izaje',
             ),
             ));
        $this->hasColumn('billable_gallons', 'decimal', null, array(
             'type' => 'decimal',
             'default' => 0,
             ));
        $this->hasColumn('non_billable_gallons', 'decimal', null, array(
             'type' => 'decimal',
             'default' => 0,
             ));
        $this->hasColumn('iquitos_gallons', 'decimal', null, array(
             'type' => 'decimal',
             'default' => 0,
             ));
        $this->hasColumn('billable_time', 'decimal', null, array(
             'type' => 'decimal',
             'default' => 0,
             ));
        $this->hasColumn('initial_billable_time', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             'default' => 0,
             ));
        $this->hasColumn('assigned_billable_time', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             'default' => 0,
             ));
        $this->hasColumn('starting_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => false,
             ));
        $this->hasColumn('stopping_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => false,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Trip', array(
             'local' => 'trip_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Location as Origin', array(
             'local' => 'origin_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Location as Destination', array(
             'local' => 'destination_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasMany('ClosedStretch as Copy', array(
             'local' => 'id',
             'foreign' => 'stretch_id'));

        $this->hasMany('StretchManifestDetail as ManifestDetails', array(
             'local' => 'id',
             'foreign' => 'stretch_id'));

        $this->hasMany('PassengerManifestDetail as PassengerManifestDetailsAsOrigin', array(
             'local' => 'id',
             'foreign' => 'stretch_origin_id'));

        $this->hasMany('PassengerManifestDetail as PassengerManifestDetailsAsDestination', array(
             'local' => 'id',
             'foreign' => 'stretch_destination_id'));

        $this->hasMany('CargoManifestDetail as CargoManifestDetailsAsOrigin', array(
             'local' => 'id',
             'foreign' => 'stretch_origin_id'));

        $this->hasMany('CargoManifestDetail as CargoManifestDetailsAsDestination', array(
             'local' => 'id',
             'foreign' => 'stretch_destination_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}