<?php

/**
 * BasePerson
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property enum $doc_type
 * @property string $doc_number
 * @property string $firstname
 * @property string $last_name
 * @property decimal $weight
 * @property integer $company_id
 * @property integer $job_id
 * @property integer $cost_center_id
 * @property boolean $is_active
 * @property Company $Company
 * @property Job $Job
 * @property CostCenter $CostCenter
 * @property Doctrine_Collection $CrewpersonManifestDetails
 * @property Doctrine_Collection $PassengerManifestDetails
 * 
 * @method enum                getDocType()                   Returns the current record's "doc_type" value
 * @method string              getDocNumber()                 Returns the current record's "doc_number" value
 * @method string              getFirstname()                 Returns the current record's "firstname" value
 * @method string              getLastName()                  Returns the current record's "last_name" value
 * @method decimal             getWeight()                    Returns the current record's "weight" value
 * @method integer             getCompanyId()                 Returns the current record's "company_id" value
 * @method integer             getJobId()                     Returns the current record's "job_id" value
 * @method integer             getCostCenterId()              Returns the current record's "cost_center_id" value
 * @method boolean             getIsActive()                  Returns the current record's "is_active" value
 * @method Company             getCompany()                   Returns the current record's "Company" value
 * @method Job                 getJob()                       Returns the current record's "Job" value
 * @method CostCenter          getCostCenter()                Returns the current record's "CostCenter" value
 * @method Doctrine_Collection getCrewpersonManifestDetails() Returns the current record's "CrewpersonManifestDetails" collection
 * @method Doctrine_Collection getPassengerManifestDetails()  Returns the current record's "PassengerManifestDetails" collection
 * @method Person              setDocType()                   Sets the current record's "doc_type" value
 * @method Person              setDocNumber()                 Sets the current record's "doc_number" value
 * @method Person              setFirstname()                 Sets the current record's "firstname" value
 * @method Person              setLastName()                  Sets the current record's "last_name" value
 * @method Person              setWeight()                    Sets the current record's "weight" value
 * @method Person              setCompanyId()                 Sets the current record's "company_id" value
 * @method Person              setJobId()                     Sets the current record's "job_id" value
 * @method Person              setCostCenterId()              Sets the current record's "cost_center_id" value
 * @method Person              setIsActive()                  Sets the current record's "is_active" value
 * @method Person              setCompany()                   Sets the current record's "Company" value
 * @method Person              setJob()                       Sets the current record's "Job" value
 * @method Person              setCostCenter()                Sets the current record's "CostCenter" value
 * @method Person              setCrewpersonManifestDetails() Sets the current record's "CrewpersonManifestDetails" collection
 * @method Person              setPassengerManifestDetails()  Sets the current record's "PassengerManifestDetails" collection
 * 
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BasePerson extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('person');
        $this->hasColumn('doc_type', 'enum', 9, array(
             'type' => 'enum',
             'length' => 9,
             'values' => 
             array(
              0 => 'DNI',
              1 => 'CE',
              2 => 'PASAPORTE',
              3 => 'OTRO',
             ),
             'notnull' => true,
             ));
        $this->hasColumn('doc_number', 'string', 20, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '20',
             ));
        $this->hasColumn('firstname', 'string', 128, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '128',
             ));
        $this->hasColumn('last_name', 'string', 128, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '128',
             ));
        $this->hasColumn('weight', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => true,
             ));
        $this->hasColumn('company_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('job_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('cost_center_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => false,
             ));
        $this->hasColumn('is_active', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             'default' => 1,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Company', array(
             'local' => 'company_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Job', array(
             'local' => 'job_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('CostCenter', array(
             'local' => 'cost_center_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasMany('CrewpersonManifestDetail as CrewpersonManifestDetails', array(
             'local' => 'id',
             'foreign' => 'crewperson_id'));

        $this->hasMany('PassengerManifestDetail as PassengerManifestDetails', array(
             'local' => 'id',
             'foreign' => 'passenger_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}