<?php

/**
 * BasePassengerManifestDetail
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $trip_id
 * @property integer $stretch_origin_id
 * @property integer $stretch_destination_id
 * @property integer $passenger_id
 * @property decimal $weight
 * @property integer $cost_center_id
 * @property integer $company_id
 * @property Trip $Trip
 * @property Stretch $Origin
 * @property Stretch $Destination
 * @property CostCenter $CostCenter
 * @property Person $Person
 * @property Company $Company
 * @property Doctrine_Collection $StretchDetails
 * @property Doctrine_Collection $Tareos
 * 
 * @method integer                 getTripId()                 Returns the current record's "trip_id" value
 * @method integer                 getStretchOriginId()        Returns the current record's "stretch_origin_id" value
 * @method integer                 getStretchDestinationId()   Returns the current record's "stretch_destination_id" value
 * @method integer                 getPassengerId()            Returns the current record's "passenger_id" value
 * @method decimal                 getWeight()                 Returns the current record's "weight" value
 * @method integer                 getCostCenterId()           Returns the current record's "cost_center_id" value
 * @method integer                 getCompanyId()              Returns the current record's "company_id" value
 * @method Trip                    getTrip()                   Returns the current record's "Trip" value
 * @method Stretch                 getOrigin()                 Returns the current record's "Origin" value
 * @method Stretch                 getDestination()            Returns the current record's "Destination" value
 * @method CostCenter              getCostCenter()             Returns the current record's "CostCenter" value
 * @method Person                  getPerson()                 Returns the current record's "Person" value
 * @method Company                 getCompany()                Returns the current record's "Company" value
 * @method Doctrine_Collection     getStretchDetails()         Returns the current record's "StretchDetails" collection
 * @method Doctrine_Collection     getTareos()                 Returns the current record's "Tareos" collection
 * @method PassengerManifestDetail setTripId()                 Sets the current record's "trip_id" value
 * @method PassengerManifestDetail setStretchOriginId()        Sets the current record's "stretch_origin_id" value
 * @method PassengerManifestDetail setStretchDestinationId()   Sets the current record's "stretch_destination_id" value
 * @method PassengerManifestDetail setPassengerId()            Sets the current record's "passenger_id" value
 * @method PassengerManifestDetail setWeight()                 Sets the current record's "weight" value
 * @method PassengerManifestDetail setCostCenterId()           Sets the current record's "cost_center_id" value
 * @method PassengerManifestDetail setCompanyId()              Sets the current record's "company_id" value
 * @method PassengerManifestDetail setTrip()                   Sets the current record's "Trip" value
 * @method PassengerManifestDetail setOrigin()                 Sets the current record's "Origin" value
 * @method PassengerManifestDetail setDestination()            Sets the current record's "Destination" value
 * @method PassengerManifestDetail setCostCenter()             Sets the current record's "CostCenter" value
 * @method PassengerManifestDetail setPerson()                 Sets the current record's "Person" value
 * @method PassengerManifestDetail setCompany()                Sets the current record's "Company" value
 * @method PassengerManifestDetail setStretchDetails()         Sets the current record's "StretchDetails" collection
 * @method PassengerManifestDetail setTareos()                 Sets the current record's "Tareos" collection
 * 
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BasePassengerManifestDetail extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('passenger_manifest_detail');
        $this->hasColumn('trip_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('stretch_origin_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('stretch_destination_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('passenger_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('weight', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => true,
             ));
        $this->hasColumn('cost_center_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('company_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Trip', array(
             'local' => 'trip_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Stretch as Origin', array(
             'local' => 'stretch_origin_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Stretch as Destination', array(
             'local' => 'stretch_destination_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('CostCenter', array(
             'local' => 'cost_center_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Person', array(
             'local' => 'passenger_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Company', array(
             'local' => 'company_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasMany('StretchManifestDetail as StretchDetails', array(
             'local' => 'id',
             'foreign' => 'passenger_manifest_detail_id'));

        $this->hasMany('Tareo as Tareos', array(
             'local' => 'id',
             'foreign' => 'passenger_manifest_detail_id'));
    }
}