<?php

/**
 * BaseCompany
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property string $ruc
 * @property string $name
 * @property boolean $is_active
 * @property Doctrine_Collection $People
 * @property Doctrine_Collection $Vehicles
 * @property Doctrine_Collection $CrewpersonManifestDetails
 * @property Doctrine_Collection $PassengerManifestDetails
 * @property Doctrine_Collection $CargoManifestDetails
 * 
 * @method string              getRuc()                       Returns the current record's "ruc" value
 * @method string              getName()                      Returns the current record's "name" value
 * @method boolean             getIsActive()                  Returns the current record's "is_active" value
 * @method Doctrine_Collection getPeople()                    Returns the current record's "People" collection
 * @method Doctrine_Collection getVehicles()                  Returns the current record's "Vehicles" collection
 * @method Doctrine_Collection getCrewpersonManifestDetails() Returns the current record's "CrewpersonManifestDetails" collection
 * @method Doctrine_Collection getPassengerManifestDetails()  Returns the current record's "PassengerManifestDetails" collection
 * @method Doctrine_Collection getCargoManifestDetails()      Returns the current record's "CargoManifestDetails" collection
 * @method Company             setRuc()                       Sets the current record's "ruc" value
 * @method Company             setName()                      Sets the current record's "name" value
 * @method Company             setIsActive()                  Sets the current record's "is_active" value
 * @method Company             setPeople()                    Sets the current record's "People" collection
 * @method Company             setVehicles()                  Sets the current record's "Vehicles" collection
 * @method Company             setCrewpersonManifestDetails() Sets the current record's "CrewpersonManifestDetails" collection
 * @method Company             setPassengerManifestDetails()  Sets the current record's "PassengerManifestDetails" collection
 * @method Company             setCargoManifestDetails()      Sets the current record's "CargoManifestDetails" collection
 * 
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BaseCompany extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('company');
        $this->hasColumn('ruc', 'string', 11, array(
             'type' => 'string',
             'notnull' => true,
             'unique' => true,
             'length' => '11',
             ));
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'unique' => true,
             'length' => '255',
             ));
        $this->hasColumn('is_active', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             'default' => 1,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('Person as People', array(
             'local' => 'id',
             'foreign' => 'company_id'));

        $this->hasMany('Vehicle as Vehicles', array(
             'local' => 'id',
             'foreign' => 'company_id'));

        $this->hasMany('CrewpersonManifestDetail as CrewpersonManifestDetails', array(
             'local' => 'id',
             'foreign' => 'company_id'));

        $this->hasMany('PassengerManifestDetail as PassengerManifestDetails', array(
             'local' => 'id',
             'foreign' => 'company_id'));

        $this->hasMany('CargoManifestDetail as CargoManifestDetails', array(
             'local' => 'id',
             'foreign' => 'company_id'));

        $timestampable0 = new Doctrine_Template_Timestampable();
        $this->actAs($timestampable0);
    }
}