<?php

/**
 * BaseCargoManifestDetail
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $trip_id
 * @property integer $stretch_origin_id
 * @property integer $stretch_destination_id
 * @property string $description
 * @property decimal $weight
 * @property integer $cost_center_id
 * @property integer $company_id
 * @property Trip $Trip
 * @property Stretch $Origin
 * @property Stretch $Destination
 * @property CostCenter $CostCenter
 * @property Company $Company
 * @property Doctrine_Collection $StretchDetails
 * 
 * @method integer             getTripId()                 Returns the current record's "trip_id" value
 * @method integer             getStretchOriginId()        Returns the current record's "stretch_origin_id" value
 * @method integer             getStretchDestinationId()   Returns the current record's "stretch_destination_id" value
 * @method string              getDescription()            Returns the current record's "description" value
 * @method decimal             getWeight()                 Returns the current record's "weight" value
 * @method integer             getCostCenterId()           Returns the current record's "cost_center_id" value
 * @method integer             getCompanyId()              Returns the current record's "company_id" value
 * @method Trip                getTrip()                   Returns the current record's "Trip" value
 * @method Stretch             getOrigin()                 Returns the current record's "Origin" value
 * @method Stretch             getDestination()            Returns the current record's "Destination" value
 * @method CostCenter          getCostCenter()             Returns the current record's "CostCenter" value
 * @method Company             getCompany()                Returns the current record's "Company" value
 * @method Doctrine_Collection getStretchDetails()         Returns the current record's "StretchDetails" collection
 * @method CargoManifestDetail setTripId()                 Sets the current record's "trip_id" value
 * @method CargoManifestDetail setStretchOriginId()        Sets the current record's "stretch_origin_id" value
 * @method CargoManifestDetail setStretchDestinationId()   Sets the current record's "stretch_destination_id" value
 * @method CargoManifestDetail setDescription()            Sets the current record's "description" value
 * @method CargoManifestDetail setWeight()                 Sets the current record's "weight" value
 * @method CargoManifestDetail setCostCenterId()           Sets the current record's "cost_center_id" value
 * @method CargoManifestDetail setCompanyId()              Sets the current record's "company_id" value
 * @method CargoManifestDetail setTrip()                   Sets the current record's "Trip" value
 * @method CargoManifestDetail setOrigin()                 Sets the current record's "Origin" value
 * @method CargoManifestDetail setDestination()            Sets the current record's "Destination" value
 * @method CargoManifestDetail setCostCenter()             Sets the current record's "CostCenter" value
 * @method CargoManifestDetail setCompany()                Sets the current record's "Company" value
 * @method CargoManifestDetail setStretchDetails()         Sets the current record's "StretchDetails" collection
 * 
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
abstract class BaseCargoManifestDetail extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('cargo_manifest_detail');
        $this->hasColumn('trip_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('stretch_origin_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('stretch_destination_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('description', 'string', 200, array(
             'type' => 'string',
             'notnull' => true,
             'length' => '200',
             ));
        $this->hasColumn('weight', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => true,
             ));
        $this->hasColumn('cost_center_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('company_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Trip', array(
             'local' => 'trip_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Stretch as Origin', array(
             'local' => 'stretch_origin_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Stretch as Destination', array(
             'local' => 'stretch_destination_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('CostCenter', array(
             'local' => 'cost_center_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasOne('Company', array(
             'local' => 'company_id',
             'foreign' => 'id',
             'onDelete' => 'CASCADE'));

        $this->hasMany('StretchManifestDetail as StretchDetails', array(
             'local' => 'id',
             'foreign' => 'cargo_manifest_detail_id'));
    }
}