<?php

class VehicleUnavailabilityTable extends Doctrine_Table
{

    /**
     * Retrieves all vehicles with trips with departure in the given date
     * 
     * @param <type> $date
     * @param <type> $category
     * @return <type> 
     */
    static function getByDateRange($start_date, $end_date) {

        return Doctrine_Query::create()
                ->from('VehicleUnavailability u')
                ->where('u.start_date >= ?', $start_date)
                ->andWhere('u.start_date <= ?', $end_date)
                ->execute();
    }

}
