<?php

/**
 * Trip
 *
 * This class has been auto-generated by the Doctrine ORM Framework
 *
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 *
 * @method booblean             getVehicleId()                 Returns the current record's "vehicle_id" value
 *
 */
class Trip extends BaseTrip {

    /**
     * Ask to their stretches if has times and if any has times returns true
     *
     * @return boolean
     */
    public function hasTimes() {
        $has = false;
        foreach ($this->Stretches as $stretch) {
            if($stretch->hasTimes()) {
                $has = true;
            }
        }
        return $has;
    }


    /**
     * Returns true if has Manifests
     *
     * @return boolean
     */
    public function hasManifests() {
        $has = false;
        foreach ($this->CrewpersonManifestDetails as $manifest) {
            $has = true;
        }
        foreach ($this->PassengerManifestDetailsAsOrigin as $manifest) {
            $has = true;
        }
        foreach ($this->CargoManifestDetailsAsOrigin as $manifest) {
            $has = true;
        }
        return $has;
    }


    /**
     * Returns true if the Trip was canceled
     * (only wrapper)
     *
     * @return boolean
     */
    public function isCanceled() {
        return $this->canceled;
    }


    /**
     * Returns true if the Trip's Stretches matchs with the given array
     *
     * @param int[] $destinations
     * @return boolean
     *
     *
     */
    public function hasThisDestinations($destinations) {
        $has = true;
        $i=0;
        if($this->Stretches->count()==count($destinations)) {
            foreach ($this->Stretches as $stretch) {
                if($stretch->Destination->id!=$destinations[$i]) {
                    $has = false;
                }
                $i++;
            }
        }else {
            $has = false;
        }
        return $has;
    }



    /**
     * Returns true if hasn't times, manifest either is canceled,
     * so has editables stretches
     *
     * @return boolean
     */
    public function hasEditableStretches() {
        return !($this->hasTimes() || $this->hasManifests() || $this->isCanceled() );
    }


    /**
     * Returns all destinations id of theirs stretches
     * @return array Location
     */
    public function getDestinationsIds(){
        $destinations = array();
        foreach ($this->Stretches as $stretch) {
            array_push($destinations, $stretch->Destination->id);
        }
        return $destinations;
    }


    /**
     * parseDuration change duration format from form format to db format
     * @param   string  $form_duration  A string like '1d 8h 45m' (form field)
     * @return  string                  A string like '1 8:45:00' (db time type)
     */
    public static function parseDuration($form_duration) {
        $parsed_duration = null;
        if (preg_match(editTripForm::$pattern, $form_duration, $parts)) {
            $duration['days'] = isset($parts['days'])?(int) $parts['days']:0;
            $duration['hours'] = isset($parts['hours'])?(int) $parts['hours']:0;
            $duration['minutes'] = isset($parts['minutes'])?(int) $parts['minutes']:0;
            $parsed_duration = sprintf("%d %d:%d:00", $duration['days'], $duration['hours'], $duration['minutes']);
        }
        return $parsed_duration;
    }

    
    /**
     * renderDuration change duration format from db format to form format
     * @param   string  $db_duration    A string like '32:45:00' (db time type)
     * @return  string                  A string like '1d 8h 45m' (form field)
     */
    public static function renderDuration($db_duration){
        list($hours,$minutes,$seconds) = explode(':',$db_duration);
        $days = floor($hours/24) > 0 ? floor($hours/24) . 'd ' : '';
        $hours = $hours % 24 > 0 ? $hours % 24 . 'h ' : '';
        $minutes = $minutes > 0 ? (int) $minutes . 'm' : '';
        return trim($days.$hours.$minutes);
    }

    public function updatePrecalculatedFields(){

        /* Deleting all the SMD objects in the trip, stretch by strech */
        foreach($this->getStretches() as $stretch) {
            StretchManifestDetail::deleteSMD($stretch);
        }

        /* Updating passenger manifest detail objects */
        foreach ($this->PassengerManifestDetailsAsOrigin as $ManifestDetail) {
            $ManifestDetail->updateDistanceXWeight();
        }

        /* Updating cargo manifest detail objects */
        foreach ($this->CargoManifestDetailsAsOrigin as $ManifestDetail) {
            $ManifestDetail->updateDistanceXWeight();
        }

        /* Updating minutes and costs */
        foreach($this->Stretches as $Stretch){
            $Stretch->updateMinutes();
        }

    }

}
