<?php

/**
 * StretchManifestDetail
 *
 * This class has been auto-generated by the Doctrine ORM Framework
 *
 * @package    PLM
 * @subpackage model
 * @author     Aureal_Systems
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
class StretchManifestDetail extends BaseStretchManifestDetail {


    public static function deleteSMD(Stretch $stretch) {
        $details = Doctrine_Query::create()
                ->from('StretchManifestDetail smd')
                ->where('smd.stretch_id = ?', $stretch->id )
                ->execute();
        foreach($details as $smd) {
          $smd->delete();
        }
    }

    public static function createSMD(Stretch $stretch, $type, $manifest_detail_id ) {

        if($type!='passenger' and $type!='cargo' ) {
            throw new PLMException('Valor no válido para StretchManifestDetail.type');
        }

        $smd = Doctrine_Query::create()
                ->from('StretchManifestDetail smd')
                ->where('smd.stretch_id = ?', $stretch->id )
                ->andWhere('smd.type = ?', $type )
                ->andWhere('smd.' . $type . '_manifest_detail_id = ?', $manifest_detail_id );

        $smd = new StretchManifestDetail();
        $smd->type = $type;
        $smd->link('Stretch', $stretch->id );
        $smd->link(ucfirst($type).'ManifestDetail', $manifest_detail_id );
        $smd->save();

        $smd->updateWXD($stretch, $manifest_detail_id);

    }

    private function updateWXD($stretch, $manifest_detail_id) {
        $distance = Doctrine_Query::create()
                //->select('d.distance')
                ->from('Distance d')
                ->where('d.origin_id = ?', min($this->Stretch->origin_id,$this->Stretch->destination_id) )
                ->andWhere('d.destination_id = ?', max($this->Stretch->origin_id,$this->Stretch->destination_id) )
                ->fetchOne();
        if($distance) {
            $ucfType = ucfirst($this->type).'ManifestDetail';
            $this->weight_x_distance = $distance['distance'] * $this->$ucfType->weight;
            $this->save();
        }else {
            throw new PLMException(
            sprintf('No está registrada la distancia de la manga: %s -> %s ',
            $this->Stretch->Origin,
            $this->Stretch->Destination
            ));
        }

    }

    public function updateMinutes($totalWeightXDistance,$billableTime) {
        $this->minutes = $totalWeightXDistance==0?0: ($this->weight_x_distance / $totalWeightXDistance) * $billableTime;
        //$this->minutes = $totalWeightXDistance==0?0: $this->weight_x_distance / $totalWeightXDistance;
        $this->save();

    }

    /**
     * In this method we do the following:
     * 1.- Read the value for minutes assigned to this StretchManifestDetail object
     * 2.- Call the convertToMonetaryValue() method of the associated Stretch and get monetary value with the minutes as parameter
     * 3.- Get and set the monetary value for this StretchManifestDetail object
     */

    public function updateMonetaryValue() {
        $this->setMonetaryValue( $this->getStretch()->convertToMonetaryValue( $this->getMinutes()) );
        $this->save();
    }

}
