<?php

/**
 * Stretch
 *
 * This class has been auto-generated by the Doctrine ORM Framework
 *
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 6820 2009-11-30 17:27:49Z jwage $
 */
class Stretch extends BaseStretch {

    /*
   * String representation of an stretch
    */
    public function __toString() {
        return $this->Origin ."-". $this->Destination;
    }

    /*
   * String representation for origin combo widgets
    */
    public function __toOriginComboString() {
        // get the stretch ordinal
        $q = Doctrine_Query::create()
                ->select(' COUNT(s.id) as order_id')
                ->from('Stretch s')
                ->where('s.trip_id = ?', $this->Trip->id)
                ->andWhere('s.id <= ?', $this->id)
                ->fetchArray();
        return sprintf("%d-%s", $q[0]['order_id'], $this->getOrigin()->getShortName());
    }

    /*
   * String representation for destination combo widgets
    */
    public function __toDestinationComboString() {
        // get the stretch ordinal
        $q = Doctrine_Query::create()
                ->select(' COUNT(s.id) as order_id')
                ->from('Stretch s')
                ->where('s.trip_id = ?', $this->Trip->id)
                ->andWhere('s.id <= ?', $this->id)
                ->fetchArray();

        return sprintf("%d-%s", $q[0]['order_id'], $this->getDestination()->getShortName());
    }


    /**
     * return true if any *_time was setted
     *
     * @return boolean
     */
    public function hasTimes() {
        $has = false;
        if (!empty($this->engine_start_time)) {
            $has = true;
        }
        if (!empty($this->takeoff_time)) {
            $has = true;
        }
        if (!empty($this->departure_time)) {
            $has = true;
        }
        if (!empty($this->arrival_time)) {
            $has = true;
        }
        if (!empty($this->landing_time)) {
            $has = true;
        }
        if (!empty($this->engine_stop_time)) {
            $has = true;
        }
        return $has;
    }

    public function updateMinutes() {

        $totalMinutes = $this->getTotalMinutes();
        $billableTime = $this->getBillableTime();
        foreach($this->ManifestDetails as $manifestDetail) {
            $manifestDetail->updateMinutes($totalMinutes, $billableTime);
            $manifestDetail->updateMonetaryValue();
        }

    }

    public function getTotalMinutes() {// in minutes
        $t = 0;
        foreach($this->ManifestDetails as $ManifestDetail) {
            $t += $ManifestDetail->weight_x_distance;
        }
        return $t;
    }

    public function hasEngineStart() {
        return intval(strtotime($this->getEngineStartTime()))>0;
    }

    public function hasTakeoff() {
        return intval(strtotime($this->getTakeoffTime()))>0;
    }

    public function hasDeparture() {
        return intval(strtotime($this->getDepartureTime()))>0;
    }

    public function hasArrival() {
        return intval(strtotime($this->getArrivalTime()))>0;
    }

    public function hasLanding() {
        return intval(strtotime($this->getLandingTime()))>0;
    }

    public function hasEngineStop() {
        return intval(strtotime($this->getEngineStopTime()))>0;
    }

    public function calculateStartingTime() {
        if ($this->Trip->Vehicle->getContractType()=='Encendido/Apagado') {
            /* Start choices */
            $start_choices = array();
            if ($this->hasEngineStart()>0) {
                $start_choices[] = strtotime($this->getEngineStartTime());
            }
            if ($this->hasTakeoff()) {
                $start_choices[] = strtotime($this->getTakeoffTime());
            }
            if ($this->hasDeparture()) {
                $start_choices[] = strtotime($this->getDepartureTime());
            }
            /* Data is available, we can do the calculation */
            if (count($start_choices)>0) {
                return date('Y-m-d H:i:s', max($start_choices));
            /* Data is not yet available so the calculation can not be done at this point in time */
            } else {
                return false;
            }
        } elseif ($this->Trip->Vehicle->getContractType()=='Tiempo en el Aire') {
            /* Start choices */
            $start_choices = array();
            if ($this->hasTakeoff()) {
                $start_choices[] = strtotime($this->getTakeoffTime());
            }
            if ($this->hasDeparture()) {
                $start_choices[] = strtotime($this->getDepartureTime());
            }
            /* Data is available, we can do the calculation */
            if (count($start_choices)>0) {
                return date('Y-m-d H:i:s', max($start_choices));
            /* Data is not yet available so the calculation can not be done at this point in time */
            } else {
                return false;
            }
        } else {
            throw new PLMException('Valor no válido para Vehicle.contract_type');
        }
    }

    public function calculateStoppingTime() {
        /* FIXME: Do not calculate min and max, use the semantics of each time */
        if ($this->getTrip()->getVehicle()->getContractType()=='Encendido/Apagado') {
            if ($this->hasEngineStop()) {
                /* End choices */
                $end_choices = array(strtotime($this->getEngineStopTime()));
                if ($this->hasArrival()) {
                    $end_choices[] = strtotime($this->getArrivalTime());
                }
                if (strtotime($this->hasLanding())>0) {
                    $end_choices[] = strtotime($this->getLandingTime());
                }
                /* Data is available, we can do the calculation */
                if (count($end_choices)>0) {
                    return date('Y-m-d H:i:s', max($end_choices));
                /* Data is not yet available so the calculation can not be done at this point in time */
                } else {
                    return false;
                }
            } else {
                /* Stopping time can not be determined at this point in time.
                   We need the next stretch of the same vehicle to start at 
                   least. */
                return false;
            }
        } elseif ($this->getTrip()->getVehicle()->getContractType()=='Tiempo en el Aire') {
            /* End choices */
            $end_choices = array();
            if ($this->hasArrival()) {
                $end_choices[] = strtotime($this->getArrivalTime());
            }
            if ($this->hasLanding()) {
                $end_choices[] = strtotime($this->getLandingTime());
            }
            /* Data is available, we can do the calculation */
            if (count($end_choices)>0) {
                return date('Y-m-d H:i:s', max($end_choices));
            /* Data is not yet available so the calculation can not be done at this point in time */
            } else {
                return false;
            }
        } else {
            throw new PLMException('Valor no válido para Vehicle.contract_type');
        }
    }

    public function updateStartingTime($save = true) {
        $this->setStartingTime( $this->calculateStartingTime() ); 
        if ($save) {
            $this->save();
        }
    }

    public function updateStoppingTime($value = NULL, $save = true) {
        if ($value) {
            $this->setStoppingTime($value);
        } else {
            $stopping_time = $this->calculateStoppingTime();
            if ($stopping_time) {
                $this->setStoppingTime( $stopping_time );
            }
        }
        if ($save) {
            $this->save();
        }
    }

    public function findPreviousStretch() {
        return Doctrine_Query::create()
                ->from('Stretch s')
                ->innerJoin('s.Trip t')
                ->where('t.vehicle_id = ?', $this->getTrip()->getVehicle()->getId())
                ->andWhere('s.starting_time < ?', $this->getStartingTime())
                ->orderBy('s.starting_time DESC')
                ->fetchOne();
    }

    public function updatePreviousStretch($save = true) {
        $previous_stretch = $this->findPreviousStretch();
        if ($previous_stretch) {
            if (!$previous_stretch->getStoppingTime()) {
                $previous_stretch->setStoppingTime( $this->getStartingTime() );
                if ($save) {
                    $previous_stretch->save();
                    /* Set the values and save in the database */
                    $previous_stretch->updateBillableTime(true);
                } else {
                    /* Just set the values do not save in the database */
                    $previous_stretch->updateBillableTime(false);
                }
                return true;
            }
        }
        return false;
    }

    public function calculateBillableTime() { // in minutes
        $start = strtotime($this->calculateStartingTime());
        $stop = $this->calculateStoppingTime();
        /* If stopping time depends on engine stop, try to read it from the database */
        if ($stop) {
            $stop = strtotime($stop);
        } else {
            $stopping_time = $this->getStoppingTime();
            /* Found, the stopping time has been updated in the stretch */
            if ($stopping_time) {
                $stop = strtotime($stopping_time);
            /* Not found, the stopping time can't be determined */
            } else {
                $stop = 0;
            }
        }
        if (intval($start)>0 && intval($stop)>0) {
            // MySQL formula
            //round(time_to_sec(timediff(engine_stop_time, engine_start_time ))/60)
            return round(($stop-$start)/60);
        } else {
            return 0.0;
        }
    }

    public function updateBillableTime($save = true) {
        $billable_time = $this->calculateBillableTime();
        $month_billable_time = $this->getTrip()->getVehicle()->getMonthBillableTime();
        $new_month_billable_time = $month_billable_time + $billable_time;
        $this->setInitialBillableTime( $month_billable_time );
        $this->setAssignedBillableTime(0);
        $this->setBillableTime( $billable_time );
        if ($save) {
            $this->save();
            $this->getTrip()->getVehicle()->setMonthBillableTime( $new_month_billable_time );
            $this->getTrip()->getVehicle()->save();
        }
    }


    private function updateAssignedBillableTime($minutes) {
        $this->setAssignedBillableTime( $this->getAssignedBillableTime() + $minutes );
        $this->save();
    }

    public function getSteppedHourlyRatesFromVehicle() {
        return $this->getTrip()->getVehicle()->getSteppedHourlyRatesAsArray();
    }

    public function convertToMonetaryValue($minutes) {
        /* Get the stepped hourly rates in descending order reversing the array.
           The second parameter to array_reverse() is a flag for preserving the keys. */
        $stepped_hourly_rates = array_reverse( $this->getSteppedHourlyRatesFromVehicle(), true);
        /* Calculate the number of minutes we are starting with */
        $start = $this->getInitialBillableTime() + $this->getAssignedBillableTime();
        /* Aditional variable initializations */
        $monetary_value = 0.0;
        $minutes_to_assign = $minutes;
        $current_rate = 0.0;
        $minutes_left = 0;
        $step_upper_limit = intval(PHP_INT_MAX/60);
        while ( $minutes_to_assign > 0 ) {
            /* Find current rate and minutes left */
            foreach($stepped_hourly_rates as $step_lower_limit => $rate) {
                /* If the number of minutes we start with is lower than
                   the step's lower_limit we descend to the next step */
                if ($start < $step_lower_limit*60) {
                    /* last lower limit is the next upper limit */
                    $step_upper_limit = $step_lower_limit;
                    continue;
                }
                /* Found rate */
                $current_rate = $rate;
                /* Minutes left in the step */
                $minutes_left = $step_upper_limit*60 - $start;
                /* Step has been found, no need to keep searching */
                break;
            }
            /* The minutes to assign fit in the minutes left */
            if ($minutes_to_assign <= $minutes_left) {
                $money_to_add = $minutes_to_assign * ($rate/60);
                /* Monetary value gets accumulated */
                $monetary_value += $money_to_add;
                /* No more minutes to assign, we have finished. */
                $minutes_to_assign = 0;
                /* The minutes to assign exceed the minutes left */
            } else {
                $money_to_add = $minutes_left * ($rate/60);
                /* Monetary value gets accumulated */
                $monetary_value += $money_to_add;
                /* The minutes to assign get updated to the ramainder */
                $minutes_to_assign -= $minutes_left;
                /* The starting point gets updated for the next iteration */
                $start += $minutes_left;
            }
        }
        /* The assigned_billable_time field of the Stretch gets updated */
        $this->updateAssignedBillableTime($minutes);
        return $monetary_value;
    }

    public function getTotalWeight() {
        return $this->getPassengerWeight()+$this->getCargoWeight();
    }

    public function getFuelLocation() {
        if ($this->getBillableGallons()>0.0) {
            return 'LBC';
        }
        if ($this->getNonBillableGallons()>0.0) {
            return 'LBC';
        }
        if ($this->getIquitosGallons()>0.0) {
            return 'Iquitos';
        }
        return false;
    }

    public function getFuelAmount() {
        if ($this->getBillableGallons()>0.0) {
            return $this->getBillableGallons;
        }
        if ($this->getNonBillableGallons()>0.0) {
            return $this->getNonBillableGallons;
        }
        if ($this->getIquitosGallons()>0.0) {
            return $this->getIquitosGallons();
        }
    }

}
