<?php

/**
 * VehicleUnavailability form base class.
 *
 * @method VehicleUnavailability getObject() Returns the current form's model object
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseVehicleUnavailabilityForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'           => new sfWidgetFormInputHidden(),
      'vehicle_id'   => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Vehicle'), 'add_empty' => false)),
      'start_date'   => new sfWidgetFormInputText(),
      'end_date'     => new sfWidgetFormInputText(),
      'observations' => new sfWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'id'           => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'vehicle_id'   => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Vehicle'))),
      'start_date'   => new sfValidatorPass(),
      'end_date'     => new sfValidatorPass(array('required' => false)),
      'observations' => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('vehicle_unavailability[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'VehicleUnavailability';
  }

}
