<?php

/**
 * Vehicle form base class.
 *
 * @method Vehicle getObject() Returns the current form's model object
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseVehicleForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'                      => new sfWidgetFormInputHidden(),
      'company_id'              => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Company'), 'add_empty' => false)),
      'plate'                   => new sfWidgetFormInputText(),
      'category'                => new sfWidgetFormChoice(array('choices' => array('Aereo' => 'Aereo', 'Fluvial' => 'Fluvial'))),
      'model_name'              => new sfWidgetFormInputText(),
      'hard_weight_limit'       => new sfWidgetFormInputText(),
      'safe_weight_limit'       => new sfWidgetFormInputText(),
      'max_passengers'          => new sfWidgetFormInputText(),
      'monthly_cost'            => new sfWidgetFormInputText(),
      'per_trip_cost'           => new sfWidgetFormInputText(),
      'min_hours'               => new sfWidgetFormInputText(),
      'hourly_fuel_consumption' => new sfWidgetFormInputText(),
      'contract_type'           => new sfWidgetFormChoice(array('choices' => array('Encendido/Apagado' => 'Encendido/Apagado', 'Tiempo en el Aire' => 'Tiempo en el Aire'))),
      'mobilization_cost'       => new sfWidgetFormInputText(),
      'demobilization_cost'     => new sfWidgetFormInputText(),
      'stepped_hourly_rates'    => new sfWidgetFormInputText(),
      'month_billable_time'     => new sfWidgetFormInputText(),
      'is_active'               => new sfWidgetFormInputCheckbox(),
      'created_at'              => new sfWidgetFormDateTime(),
      'updated_at'              => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'id'                      => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'company_id'              => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Company'))),
      'plate'                   => new sfValidatorString(array('max_length' => 20)),
      'category'                => new sfValidatorChoice(array('choices' => array('Aereo' => 'Aereo', 'Fluvial' => 'Fluvial'))),
      'model_name'              => new sfValidatorString(array('max_length' => 50)),
      'hard_weight_limit'       => new sfValidatorInteger(),
      'safe_weight_limit'       => new sfValidatorInteger(),
      'max_passengers'          => new sfValidatorInteger(array('required' => false)),
      'monthly_cost'            => new sfValidatorNumber(array('required' => false)),
      'per_trip_cost'           => new sfValidatorNumber(array('required' => false)),
      'min_hours'               => new sfValidatorInteger(array('required' => false)),
      'hourly_fuel_consumption' => new sfValidatorNumber(array('required' => false)),
      'contract_type'           => new sfValidatorChoice(array('choices' => array('Encendido/Apagado' => 'Encendido/Apagado', 'Tiempo en el Aire' => 'Tiempo en el Aire'), 'required' => false)),
      'mobilization_cost'       => new sfValidatorNumber(array('required' => false)),
      'demobilization_cost'     => new sfValidatorNumber(array('required' => false)),
      'stepped_hourly_rates'    => new sfValidatorPass(array('required' => false)),
      'month_billable_time'     => new sfValidatorInteger(array('required' => false)),
      'is_active'               => new sfValidatorBoolean(array('required' => false)),
      'created_at'              => new sfValidatorDateTime(),
      'updated_at'              => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('vehicle[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Vehicle';
  }

}
