<?php

/**
 * UserAccount form base class.
 *
 * @method UserAccount getObject() Returns the current form's model object
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseUserAccountForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'               => new sfWidgetFormInputHidden(),
      'sf_guard_user_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'), 'add_empty' => false)),
      'firstname'        => new sfWidgetFormInputText(),
      'lastname'         => new sfWidgetFormInputText(),
      'gender'           => new sfWidgetFormChoice(array('choices' => array('Masculino' => 'Masculino', 'Femenino' => 'Femenino'))),
      'email'            => new sfWidgetFormInputText(),
      'created_at'       => new sfWidgetFormDateTime(),
      'updated_at'       => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'id'               => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'sf_guard_user_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'))),
      'firstname'        => new sfValidatorString(array('max_length' => 64)),
      'lastname'         => new sfValidatorString(array('max_length' => 64, 'required' => false)),
      'gender'           => new sfValidatorChoice(array('choices' => array('Masculino' => 'Masculino', 'Femenino' => 'Femenino'))),
      'email'            => new sfValidatorString(array('max_length' => 64)),
      'created_at'       => new sfValidatorDateTime(),
      'updated_at'       => new sfValidatorDateTime(),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'UserAccount', 'column' => array('sf_guard_user_id')))
    );

    $this->widgetSchema->setNameFormat('user_account[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'UserAccount';
  }

}
