<?php

/**
 * Trip form base class.
 *
 * @method Trip getObject() Returns the current form's model object
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseTripForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'                  => new sfWidgetFormInputHidden(),
      'vehicle_id'          => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Vehicle'), 'add_empty' => false)),
      'origin_id'           => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Origin'), 'add_empty' => false)),
      'departure_date'      => new sfWidgetFormDate(),
      'arrival_date'        => new sfWidgetFormDate(),
      'description'         => new sfWidgetFormInputText(),
      'notes'               => new sfWidgetFormInputText(),
      'estimated_departure' => new sfWidgetFormInputText(),
      'estimated_duration'  => new sfWidgetFormTime(),
      'type'                => new sfWidgetFormChoice(array('choices' => array('Aereo' => 'Aereo', 'Fluvial' => 'Fluvial'))),
      'cost'                => new sfWidgetFormInputText(),
      'canceled'            => new sfWidgetFormInputCheckbox(),
      'closed'              => new sfWidgetFormInputCheckbox(),
      'created_at'          => new sfWidgetFormDateTime(),
      'updated_at'          => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'id'                  => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'vehicle_id'          => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Vehicle'))),
      'origin_id'           => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Origin'))),
      'departure_date'      => new sfValidatorDate(),
      'arrival_date'        => new sfValidatorDate(array('required' => false)),
      'description'         => new sfValidatorString(array('max_length' => 50)),
      'notes'               => new sfValidatorString(array('max_length' => 250, 'required' => false)),
      'estimated_departure' => new sfValidatorPass(array('required' => false)),
      'estimated_duration'  => new sfValidatorTime(array('required' => false)),
      'type'                => new sfValidatorChoice(array('choices' => array('Aereo' => 'Aereo', 'Fluvial' => 'Fluvial'))),
      'cost'                => new sfValidatorNumber(array('required' => false)),
      'canceled'            => new sfValidatorBoolean(array('required' => false)),
      'closed'              => new sfValidatorBoolean(array('required' => false)),
      'created_at'          => new sfValidatorDateTime(),
      'updated_at'          => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('trip[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Trip';
  }

}
