<?php

/**
 * Tareo form base class.
 *
 * @method Tareo getObject() Returns the current form's model object
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseTareoForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'                           => new sfWidgetFormInputHidden(),
      'doc_type'                     => new sfWidgetFormChoice(array('choices' => array('DNI' => 'DNI', 'CE' => 'CE', 'PASAPORTE' => 'PASAPORTE', 'OTRO' => 'OTRO'))),
      'doc_number'                   => new sfWidgetFormInputText(),
      'firstname'                    => new sfWidgetFormInputText(),
      'last_name'                    => new sfWidgetFormInputText(),
      'arrival'                      => new sfWidgetFormInputText(),
      'departure'                    => new sfWidgetFormInputText(),
      'company_id'                   => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Company'), 'add_empty' => true)),
      'job_id'                       => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Job'), 'add_empty' => true)),
      'location_id'                  => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Location'), 'add_empty' => false)),
      'passenger_manifest_detail_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('PassengerManifestDetail'), 'add_empty' => true)),
      'created_at'                   => new sfWidgetFormDateTime(),
      'updated_at'                   => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'id'                           => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'doc_type'                     => new sfValidatorChoice(array('choices' => array('DNI' => 'DNI', 'CE' => 'CE', 'PASAPORTE' => 'PASAPORTE', 'OTRO' => 'OTRO'), 'required' => false)),
      'doc_number'                   => new sfValidatorString(array('max_length' => 20)),
      'firstname'                    => new sfValidatorString(array('max_length' => 128)),
      'last_name'                    => new sfValidatorString(array('max_length' => 128)),
      'arrival'                      => new sfValidatorPass(),
      'departure'                    => new sfValidatorPass(),
      'company_id'                   => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Company'), 'required' => false)),
      'job_id'                       => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Job'), 'required' => false)),
      'location_id'                  => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Location'))),
      'passenger_manifest_detail_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('PassengerManifestDetail'), 'required' => false)),
      'created_at'                   => new sfValidatorDateTime(),
      'updated_at'                   => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('tareo[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Tareo';
  }

}
