<?php

/**
 * Person form base class.
 *
 * @method Person getObject() Returns the current form's model object
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BasePersonForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'             => new sfWidgetFormInputHidden(),
      'doc_type'       => new sfWidgetFormChoice(array('choices' => array('DNI' => 'DNI', 'CE' => 'CE', 'PASAPORTE' => 'PASAPORTE', 'OTRO' => 'OTRO'))),
      'doc_number'     => new sfWidgetFormInputText(),
      'firstname'      => new sfWidgetFormInputText(),
      'last_name'      => new sfWidgetFormInputText(),
      'weight'         => new sfWidgetFormInputText(),
      'company_id'     => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Company'), 'add_empty' => false)),
      'job_id'         => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Job'), 'add_empty' => false)),
      'cost_center_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('CostCenter'), 'add_empty' => true)),
      'is_active'      => new sfWidgetFormInputCheckbox(),
      'created_at'     => new sfWidgetFormDateTime(),
      'updated_at'     => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'id'             => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'doc_type'       => new sfValidatorChoice(array('choices' => array('DNI' => 'DNI', 'CE' => 'CE', 'PASAPORTE' => 'PASAPORTE', 'OTRO' => 'OTRO'))),
      'doc_number'     => new sfValidatorString(array('max_length' => 20)),
      'firstname'      => new sfValidatorString(array('max_length' => 128)),
      'last_name'      => new sfValidatorString(array('max_length' => 128)),
      'weight'         => new sfValidatorNumber(),
      'company_id'     => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Company'))),
      'job_id'         => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Job'))),
      'cost_center_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('CostCenter'), 'required' => false)),
      'is_active'      => new sfValidatorBoolean(array('required' => false)),
      'created_at'     => new sfValidatorDateTime(),
      'updated_at'     => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('person[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Person';
  }

}
