<?php

/**
 * PassengerManifestDetail form base class.
 *
 * @method PassengerManifestDetail getObject() Returns the current form's model object
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BasePassengerManifestDetailForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'                     => new sfWidgetFormInputHidden(),
      'trip_id'                => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Trip'), 'add_empty' => false)),
      'stretch_origin_id'      => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Origin'), 'add_empty' => false)),
      'stretch_destination_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Destination'), 'add_empty' => false)),
      'passenger_id'           => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Person'), 'add_empty' => false)),
      'weight'                 => new sfWidgetFormInputText(),
      'cost_center_id'         => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('CostCenter'), 'add_empty' => false)),
      'company_id'             => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Company'), 'add_empty' => false)),
    ));

    $this->setValidators(array(
      'id'                     => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'trip_id'                => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Trip'))),
      'stretch_origin_id'      => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Origin'))),
      'stretch_destination_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Destination'))),
      'passenger_id'           => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Person'))),
      'weight'                 => new sfValidatorNumber(),
      'cost_center_id'         => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('CostCenter'))),
      'company_id'             => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Company'))),
    ));

    $this->widgetSchema->setNameFormat('passenger_manifest_detail[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'PassengerManifestDetail';
  }

}
