<?php

/**
 * Distance form base class.
 *
 * @method Distance getObject() Returns the current form's model object
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseDistanceForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'             => new sfWidgetFormInputHidden(),
      'origin_id'      => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Origin'), 'add_empty' => false)),
      'destination_id' => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Destination'), 'add_empty' => false)),
      'distance'       => new sfWidgetFormInputText(),
      'is_active'      => new sfWidgetFormInputCheckbox(),
      'created_at'     => new sfWidgetFormDateTime(),
      'updated_at'     => new sfWidgetFormDateTime(),
    ));

    $this->setValidators(array(
      'id'             => new sfValidatorDoctrineChoice(array('model' => $this->getModelName(), 'column' => 'id', 'required' => false)),
      'origin_id'      => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Origin'))),
      'destination_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Destination'))),
      'distance'       => new sfValidatorNumber(),
      'is_active'      => new sfValidatorBoolean(array('required' => false)),
      'created_at'     => new sfValidatorDateTime(),
      'updated_at'     => new sfValidatorDateTime(),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'Distance', 'column' => array('origin_id', 'destination_id')))
    );

    $this->widgetSchema->setNameFormat('distance[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Distance';
  }

}
