<?php

/**
 * UserAccount form.
 *
 * @package    PLM
 * @subpackage form
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class UserAccountForm extends BaseUserAccountForm
{
  public function configure()
  {      

    /* Adding new fields to the form */
    $this->setWidget('sf_guard_user_id',new sfWidgetFormInputHidden());
    $this->setWidget('username',new sfWidgetFormInputText(array(),array('size'=>20)));
    $this->setWidget('new_password',new sfWidgetFormInputPassword(array(),array('size'=>20)));
    $this->setWidget('new_password_confirmation',new sfWidgetFormInputPassword(array(),array('size'=>20)));
    $this->setWidget('is_active',  new sfWidgetFormInputCheckbox());

    /* Disabling fields */
    //$this->offsetUnset('sf_guard_user_id');
    $this->offsetUnset('created_at');
    $this->offsetUnset('updated_at');

    // Labeling
    $this->widgetSchema->setLabels(array(
        'username' => 'Nombre de usuario',
        'firstname' => 'Nombres',
        'lastname' => 'Apellidos',
        'email' => 'Correo electrónico',
        'gender' => 'Género',
        'is_active' => '¿Activo?',
        'new_password' => 'Nueva contraseña',
        'new_password_confirmation' => 'Confirmación'
    ));

    /* Validations */
    $this->setValidator('sf_guard_user_id', new sfValidatorInteger(array("required"=>false)));
    $this->setValidator('username', new sfValidatorString(array("required"=>true)));
    $this->setValidator('new_password', new sfValidatorString(array("required"=>false)));
    $this->setValidator('is_active', new sfValidatorBoolean(array("required"=>false)));
    $this->setValidator('new_password_confirmation', new sfValidatorString(array("required"=>false)));

    $this->validatorSchema->setPostValidator(
            new sfValidatorSchemaCompare(
                'new_password',
                sfValidatorSchemaCompare::EQUAL,
                'new_password_confirmation',
                array('throw_global_error' => false),
                array('invalid' => 'Las contraseñas no coinciden')
            )
        );

    $this->mergePostValidator(new sfValidatorCallback(array('callback' =>
        array($this, 'checkUsernameAvailability'))));
    
  }

   
   public function checkUsernameAvailability($validator, $values) {
        $qs = Doctrine_Query::create()
                ->from('sfGuardUser u')
                ->where('u.username = ?', $values['username']);
        if (strlen($values['id'])>0) {
            $qs = $qs->andWhereNotIn('u.id', $values['sf_guard_user_id']); 
        }
        $count = $qs->count();
        if ($count>0) {
            throw new sfValidatorError($validator, 'El nombre de usuario ya está en uso');
        }
        return $values;
    }
  
}
