<?php

/**
 * Tareo form.
 *
 * @package    sf_sandbox
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrineFormTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class TareoForm extends BaseTareoForm {

    public function configure() {

        // adding 4 new widgets for date and time pickers
        $this->setWidget('arrival_date',new sfWidgetFormInputText(array(),array('size'=>10)));
        $this->setWidget('departure_date',new sfWidgetFormInputText(array(),array('size'=>10)));
        $this->setWidget('arrival_time',new sfWidgetFormInputText(array(),array('size'=>10)));
        $this->setWidget('departure_time',new sfWidgetFormInputText(array(),array('size'=>10)));

        // changing widget to 2 fields
        $this->setWidget('arrival', new sfWidgetFormInputHidden());
        $this->setWidget('departure', new sfWidgetFormInputHidden());
        
        // widgets: options and attributes
        $this->getWidget('doc_type')->setOption('choices',array_merge(array(''=>'--- Tipo Doc ---'),$this->getWidget('doc_type')->getOption('choices')));
        $this->getWidget('doc_number')->setAttribute('maxlength',$this->getValidator('doc_number')->getOption('max_length'));
        $this->getWidget('firstname')->setAttribute('maxlength',$this->getValidator('firstname')->getOption('max_length'));
        $this->getWidget('last_name')->setAttribute('maxlength',$this->getValidator('last_name')->getOption('max_length'));
        $this->getWidget('location_id')->setOption('add_empty', '--- Seleccione Destino ---');
        $this->getWidget('arrival_date')->setAttribute('size', 10);
        $this->getWidget('departure_date')->setAttribute('size', 10);
        $this->getWidget('company_id')->setOption('add_empty', '--- Seleccione Empresa ---');
        $this->getWidget('job_id')->setOption('add_empty', '--- Seleccione Puesto ---');

        // validators: options and messages
        $this->getValidator('doc_type')
                ->setOption ('required', true)
                ->setMessage('required', 'Debe seleccionar un tipo de doc.')
                ->setMessage('invalid', 'Tipo de documento inválido');
        $this->getValidator('doc_number')
                ->setOption ('min_length', 2)
                ->setMessage('required','Debe ingresar el N° de documento')
                ->setMessage('max_length','"%value%" es demasiado largo (Máximo %max_length% caracteres).')
                ->setMessage('min_length','"%value%" es demasiado corto (Mínimo %min_length% caracteres).');
        $this->getValidator('firstname')
                ->setOption ('min_length', 2)
                ->setMessage('required','Debe ingresar un nombre')
                ->setMessage('max_length','"%value%" es demasiado largo (Máximo %max_length% caracteres).')
                ->setMessage('min_length','"%value%" es demasiado corto (Mínimo %min_length% caracteres).');
        $this->getValidator('last_name')
                ->setOption ('min_length', 2)
                ->setMessage('required','Debe ingresar los apellidos')
                ->setMessage('max_length','"%value%" es demasiado largo (Máximo %max_length% caracteres).')
                ->setMessage('min_length','"%value%" es demasiado corto (Mínimo %min_length% caracteres).');
        $this->getValidator('location_id')
                ->setMessage('required', 'Debe seleccionar un destino')
                ->setMessage('invalid', 'Destino inválido');

        // adding 4 new validators for date and time pickers
        $this->setValidator('arrival_date', new sfValidatorDate(
            array(
                'date_format' => '@(?P<day>\d{2})/(?P<month>\d{2})/(?P<year>\d{4})@',
                'date_output' => 'Y-m-d'
            ),
            array(
                'required'=>'Debe ingresar una fecha',
                'invalid'=>'Fecha inválida',
                'bad_format'  => 'El formato de la fecha es (dd/mm/aaaa)'
            )
        ));
        $this->setValidator('departure_date', new sfValidatorDate(
            array(
                'date_format' => '@(?P<day>\d{2})/(?P<month>\d{2})/(?P<year>\d{4})@',
                'date_output' => 'Y-m-d'
            ),
            array(
                'required'=>'Debe ingresar una fecha',
                'invalid'=>'Fecha inválida',
                'bad_format'  => 'El formato de la fecha es (dd/mm/aaaa)'
            )
        ));
        $this->setValidator('arrival_time', new sfValidatorTime(
            array(
                'time_format' => '@(?P<hour>\d{1,2}):(?P<minute>\d{2}) (?P<amp>am|pm)@'
            ),
            array(
                'required'=>'Debe ingresar una hora',
                'invalid'=>'Hora inválida',
                'bad_format'=>'El formato es: "8:30 am"'
            )
        ));
        $this->setValidator('departure_time', new sfValidatorTime(
            array(
                'time_format' => '@(?P<hour>\d{1,2}):(?P<minute>\d{2}) (?P<amp>am|pm)@'
            ),
            array(
                'required'=>'Debe ingresar una hora',
                'invalid'=>'Hora inválida',
                'bad_format'=>'El formato es: "8:30 am"'
            )
        ));
        $this->setValidator('arrival', new sfValidatorDateTime(
            array(
                'date_format' =>    '@(?P<day>\d{2})/(?P<month>\d{2})/(?P<year>\d{4}) '.
                                    '(?P<hour>\d{1,2}):(?P<minute>\d{2}):(?P<seconds>\d{2})@'
            ),
            array(
                'required'=>'Debe ingresar la hora y fecha de Entrada',
                'invalid'=>'Hora y fecha de Entrada inválida',
                'bad_format'=>'El formato es: "23/02/2010 8:30:00"'
            )
        ));
        $this->setValidator('departure', new sfValidatorDateTime(
            array(
                'date_format' =>    '@(?P<day>\d{2})/(?P<month>\d{2})/(?P<year>\d{4}) '.
                                    '(?P<hour>\d{1,2}):(?P<minute>\d{2}):(?P<seconds>\d{2})@'
            ),
            array(
                'required'=>'Debe ingresar la hora y fecha de Salida',
                'invalid'=>'Hora y fecha de Salida inválida',
                'bad_format'=>'El formato es: "23/02/2010 8:30:00"'
        )));

        $this->validatorSchema->setPostValidator(
            new sfValidatorSchemaCompare(
                'arrival',
                sfValidatorSchemaCompare::LESS_THAN,
                'departure',
                array('throw_global_error' => true),
                array('invalid' => 'La Entrada ("%left_field%") debe ser antes de la Salida ("%right_field%")')
            )
        );
        
        // skipping some fields
        $this->offsetUnset('passenger_manifest_detail_id');
        $this->offsetUnset('created_at');
        $this->offsetUnset('updated_at');

        // Labeling
        $this->widgetSchema->setLabels(array(
                'doc_type'      =>  'Tipo de Documento',
                'doc_number'    =>  'N° de Documento',
                'firstname'     =>  'Nombres',
                'last_name'     =>  'Apellidos',
                'arrival'       =>  'Entrada',
                'departure'     =>  'Salida',
                'arrival_date'  =>  'Fecha de Entrada',
                'departure_date'=>  'Fecha de Salida',
                'arrival_time'  =>  'Hora de Entrada',
                'departure_time'=>  'Hora de Salida',
                'company_id'    =>  'Empresa',
                'job_id'        =>  'Puesto',
                'location_id'   =>  'Destino'
        ));

    }
}
