<?php

/**
 * Vehicle filter form base class.
 *
 * @package    PLM
 * @subpackage filter
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseVehicleFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'company_id'              => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Company'), 'add_empty' => true)),
      'plate'                   => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'category'                => new sfWidgetFormChoice(array('choices' => array('' => '', 'Aereo' => 'Aereo', 'Fluvial' => 'Fluvial'))),
      'model_name'              => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'hard_weight_limit'       => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'safe_weight_limit'       => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'max_passengers'          => new sfWidgetFormFilterInput(),
      'monthly_cost'            => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'per_trip_cost'           => new sfWidgetFormFilterInput(),
      'min_hours'               => new sfWidgetFormFilterInput(),
      'hourly_fuel_consumption' => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'contract_type'           => new sfWidgetFormChoice(array('choices' => array('' => '', 'Encendido/Apagado' => 'Encendido/Apagado', 'Tiempo en el Aire' => 'Tiempo en el Aire'))),
      'mobilization_cost'       => new sfWidgetFormFilterInput(),
      'demobilization_cost'     => new sfWidgetFormFilterInput(),
      'stepped_hourly_rates'    => new sfWidgetFormFilterInput(),
      'month_billable_time'     => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'is_active'               => new sfWidgetFormChoice(array('choices' => array('' => 'yes or no', 1 => 'yes', 0 => 'no'))),
      'created_at'              => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
      'updated_at'              => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => false)),
    ));

    $this->setValidators(array(
      'company_id'              => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Company'), 'column' => 'id')),
      'plate'                   => new sfValidatorPass(array('required' => false)),
      'category'                => new sfValidatorChoice(array('required' => false, 'choices' => array('Aereo' => 'Aereo', 'Fluvial' => 'Fluvial'))),
      'model_name'              => new sfValidatorPass(array('required' => false)),
      'hard_weight_limit'       => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'safe_weight_limit'       => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'max_passengers'          => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'monthly_cost'            => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'per_trip_cost'           => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'min_hours'               => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'hourly_fuel_consumption' => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'contract_type'           => new sfValidatorChoice(array('required' => false, 'choices' => array('Encendido/Apagado' => 'Encendido/Apagado', 'Tiempo en el Aire' => 'Tiempo en el Aire'))),
      'mobilization_cost'       => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'demobilization_cost'     => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'stepped_hourly_rates'    => new sfValidatorPass(array('required' => false)),
      'month_billable_time'     => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'is_active'               => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'created_at'              => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
      'updated_at'              => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 00:00:00')), 'to_date' => new sfValidatorDateTime(array('required' => false, 'datetime_output' => 'Y-m-d 23:59:59')))),
    ));

    $this->widgetSchema->setNameFormat('vehicle_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Vehicle';
  }

  public function getFields()
  {
    return array(
      'id'                      => 'Number',
      'company_id'              => 'ForeignKey',
      'plate'                   => 'Text',
      'category'                => 'Enum',
      'model_name'              => 'Text',
      'hard_weight_limit'       => 'Number',
      'safe_weight_limit'       => 'Number',
      'max_passengers'          => 'Number',
      'monthly_cost'            => 'Number',
      'per_trip_cost'           => 'Number',
      'min_hours'               => 'Number',
      'hourly_fuel_consumption' => 'Number',
      'contract_type'           => 'Enum',
      'mobilization_cost'       => 'Number',
      'demobilization_cost'     => 'Number',
      'stepped_hourly_rates'    => 'Text',
      'month_billable_time'     => 'Number',
      'is_active'               => 'Boolean',
      'created_at'              => 'Date',
      'updated_at'              => 'Date',
    );
  }
}
