<?php

/**
 * CrewpersonManifestDetail filter form base class.
 *
 * @package    PLM
 * @subpackage filter
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseCrewpersonManifestDetailFormFilter extends BaseFormFilterDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'trip_id'             => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Trip'), 'add_empty' => true)),
      'crewperson_id'       => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Person'), 'add_empty' => true)),
      'crew_position_id'    => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('CrewPosition'), 'add_empty' => true)),
      'weight'              => new sfWidgetFormFilterInput(array('with_empty' => false)),
      'company_id'          => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Company'), 'add_empty' => true)),
      'uses_passenger_seat' => new sfWidgetFormChoice(array('choices' => array('' => 'yes or no', 1 => 'yes', 0 => 'no'))),
    ));

    $this->setValidators(array(
      'trip_id'             => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Trip'), 'column' => 'id')),
      'crewperson_id'       => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Person'), 'column' => 'id')),
      'crew_position_id'    => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('CrewPosition'), 'column' => 'id')),
      'weight'              => new sfValidatorSchemaFilter('text', new sfValidatorNumber(array('required' => false))),
      'company_id'          => new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Company'), 'column' => 'id')),
      'uses_passenger_seat' => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
    ));

    $this->widgetSchema->setNameFormat('crewperson_manifest_detail_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'CrewpersonManifestDetail';
  }

  public function getFields()
  {
    return array(
      'id'                  => 'Number',
      'trip_id'             => 'ForeignKey',
      'crewperson_id'       => 'ForeignKey',
      'crew_position_id'    => 'ForeignKey',
      'weight'              => 'Number',
      'company_id'          => 'ForeignKey',
      'uses_passenger_seat' => 'Boolean',
    );
  }
}
