<?php

/**
 * ClosedStretch filter form base class.
 *
 * @package    PLM
 * @subpackage filter
 * @author     Aureal_Systems
 * @version    SVN: $Id: sfDoctrineFormFilterGeneratedInheritanceTemplate.php 24171 2009-11-19 16:37:50Z Kris.Wallsmith $
 */
abstract class BaseClosedStretchFormFilter extends StretchFormFilter
{
  protected function setupInheritance()
  {
    parent::setupInheritance();

    $this->widgetSchema   ['stretch_id'] = new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Stretch'), 'add_empty' => true));
    $this->validatorSchema['stretch_id'] = new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('Stretch'), 'column' => 'id'));

    $this->widgetSchema   ['closed_trip_id'] = new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('ClosedTrip'), 'add_empty' => true));
    $this->validatorSchema['closed_trip_id'] = new sfValidatorDoctrineChoice(array('required' => false, 'model' => $this->getRelatedModelName('ClosedTrip'), 'column' => 'id'));

    $this->widgetSchema->setNameFormat('closed_stretch_filters[%s]');
  }

  public function getModelName()
  {
    return 'ClosedStretch';
  }

  public function getFields()
  {
    return array_merge(parent::getFields(), array(
      'stretch_id' => 'ForeignKey',
      'closed_trip_id' => 'ForeignKey',
    ));
  }
}
