CREATE TABLE cargo_manifest_detail (id BIGINT AUTO_INCREMENT, trip_id BIGINT NOT NULL, stretch_origin_id BIGINT NOT NULL, stretch_destination_id BIGINT NOT NULL, description VARCHAR(200) NOT NULL, weight DECIMAL(18, 2) NOT NULL, cost_center_id BIGINT NOT NULL, company_id BIGINT NOT NULL, INDEX trip_id_idx (trip_id), INDEX stretch_origin_id_idx (stretch_origin_id), INDEX stretch_destination_id_idx (stretch_destination_id), INDEX cost_center_id_idx (cost_center_id), INDEX company_id_idx (company_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE closed_stretch (id BIGINT AUTO_INCREMENT, trip_id BIGINT, origin_id BIGINT, destination_id BIGINT, description VARCHAR(200), engine_start_time DATETIME, takeoff_time DATETIME, departure_time DATETIME, arrival_time DATETIME, landing_time DATETIME, engine_stop_time DATETIME, cargo_weight DECIMAL(18, 2), passenger_weight DECIMAL(18, 2), passenger_count BIGINT DEFAULT 0, fuel_recharge TINYINT(1) DEFAULT '0', load_type ENUM('Carga externa', 'Carga interna', 'Pasajeros', 'Carga interna y pasajeros', 'Materiales de izaje'), billable_gallons DECIMAL(18, 2) DEFAULT 0, non_billable_gallons DECIMAL(18, 2) DEFAULT 0, iquitos_gallons DECIMAL(18, 2) DEFAULT 0, billable_time DECIMAL(18, 2) DEFAULT 0, initial_billable_time BIGINT DEFAULT 0 NOT NULL, assigned_billable_time BIGINT DEFAULT 0 NOT NULL, starting_time DATETIME, stopping_time DATETIME, stretch_id BIGINT, closed_trip_id BIGINT, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX trip_id_idx (trip_id), INDEX origin_id_idx (origin_id), INDEX destination_id_idx (destination_id), INDEX stretch_id_idx (stretch_id), INDEX closed_trip_id_idx (closed_trip_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE closed_trip (id BIGINT AUTO_INCREMENT, vehicle_id BIGINT NOT NULL, origin_id BIGINT NOT NULL, departure_date DATE NOT NULL, arrival_date DATE, description VARCHAR(50) NOT NULL, notes VARCHAR(250), estimated_departure datetime, estimated_duration TIME, type ENUM('Aereo', 'Fluvial') NOT NULL, cost DECIMAL(18, 2), canceled TINYINT(1) DEFAULT '0' NOT NULL, closed TINYINT(1) DEFAULT '0' NOT NULL, trip_id BIGINT, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX vehicle_id_idx (vehicle_id), INDEX origin_id_idx (origin_id), INDEX trip_id_idx (trip_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE company (id BIGINT AUTO_INCREMENT, ruc VARCHAR(11) NOT NULL UNIQUE, name VARCHAR(255) NOT NULL UNIQUE, is_active TINYINT(1) DEFAULT '1' NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE cost_center (id BIGINT AUTO_INCREMENT, name VARCHAR(128) NOT NULL UNIQUE, is_active TINYINT(1) DEFAULT '1' NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE crew_position (id BIGINT AUTO_INCREMENT, name VARCHAR(64) NOT NULL UNIQUE, type ENUM('Aereo', 'Fluvial') NOT NULL, is_active TINYINT(1) DEFAULT '1' NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE crewperson_manifest_detail (id BIGINT AUTO_INCREMENT, trip_id BIGINT NOT NULL, crewperson_id BIGINT NOT NULL, crew_position_id BIGINT NOT NULL, weight DECIMAL(18, 2) NOT NULL, company_id BIGINT NOT NULL, uses_passenger_seat TINYINT(1) DEFAULT '0' NOT NULL, INDEX trip_id_idx (trip_id), INDEX crewperson_id_idx (crewperson_id), INDEX crew_position_id_idx (crew_position_id), INDEX company_id_idx (company_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE distance (id BIGINT AUTO_INCREMENT, origin_id BIGINT NOT NULL, destination_id BIGINT NOT NULL, distance DECIMAL(18, 2) NOT NULL, is_active TINYINT(1) DEFAULT '1' NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, UNIQUE INDEX orig_dest_idx (origin_id, destination_id), INDEX origin_id_idx (origin_id), INDEX destination_id_idx (destination_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE job (id BIGINT AUTO_INCREMENT, name VARCHAR(64) NOT NULL UNIQUE, is_active TINYINT(1) DEFAULT '1' NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE location (id BIGINT AUTO_INCREMENT, name VARCHAR(255) NOT NULL, short_name VARCHAR(3) NOT NULL, is_active TINYINT(1) DEFAULT '1' NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE passenger_manifest_detail (id BIGINT AUTO_INCREMENT, trip_id BIGINT NOT NULL, stretch_origin_id BIGINT NOT NULL, stretch_destination_id BIGINT NOT NULL, passenger_id BIGINT NOT NULL, weight DECIMAL(18, 2) NOT NULL, cost_center_id BIGINT NOT NULL, company_id BIGINT NOT NULL, INDEX trip_id_idx (trip_id), INDEX stretch_origin_id_idx (stretch_origin_id), INDEX stretch_destination_id_idx (stretch_destination_id), INDEX cost_center_id_idx (cost_center_id), INDEX passenger_id_idx (passenger_id), INDEX company_id_idx (company_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE person (id BIGINT AUTO_INCREMENT, doc_type ENUM('DNI', 'CE', 'PASAPORTE', 'OTRO') NOT NULL, doc_number VARCHAR(20) NOT NULL, firstname VARCHAR(128) NOT NULL, last_name VARCHAR(128) NOT NULL, weight DECIMAL(18, 2) NOT NULL, company_id BIGINT NOT NULL, job_id BIGINT NOT NULL, cost_center_id BIGINT, is_active TINYINT(1) DEFAULT '1' NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX company_id_idx (company_id), INDEX job_id_idx (job_id), INDEX cost_center_id_idx (cost_center_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE stretch (id BIGINT AUTO_INCREMENT, trip_id BIGINT, origin_id BIGINT, destination_id BIGINT, description VARCHAR(200), engine_start_time DATETIME, takeoff_time DATETIME, departure_time DATETIME, arrival_time DATETIME, landing_time DATETIME, engine_stop_time DATETIME, cargo_weight DECIMAL(18, 2), passenger_weight DECIMAL(18, 2), passenger_count BIGINT DEFAULT 0, fuel_recharge TINYINT(1) DEFAULT '0', load_type ENUM('Carga externa', 'Carga interna', 'Pasajeros', 'Carga interna y pasajeros', 'Materiales de izaje'), billable_gallons DECIMAL(18, 2) DEFAULT 0, non_billable_gallons DECIMAL(18, 2) DEFAULT 0, iquitos_gallons DECIMAL(18, 2) DEFAULT 0, billable_time DECIMAL(18, 2) DEFAULT 0, initial_billable_time BIGINT DEFAULT 0 NOT NULL, assigned_billable_time BIGINT DEFAULT 0 NOT NULL, starting_time DATETIME, stopping_time DATETIME, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX trip_id_idx (trip_id), INDEX origin_id_idx (origin_id), INDEX destination_id_idx (destination_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE stretch_manifest_detail (id BIGINT AUTO_INCREMENT, stretch_id BIGINT, passenger_manifest_detail_id BIGINT, cargo_manifest_detail_id BIGINT, type ENUM('passenger', 'cargo') NOT NULL, weight_x_distance DECIMAL(18, 2) DEFAULT 0 NOT NULL, minutes DECIMAL(18, 2) DEFAULT 0 NOT NULL, monetary_value DECIMAL(18, 2) DEFAULT 0 NOT NULL, INDEX stretch_id_idx (stretch_id), INDEX passenger_manifest_detail_id_idx (passenger_manifest_detail_id), INDEX cargo_manifest_detail_id_idx (cargo_manifest_detail_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE tareo (id BIGINT AUTO_INCREMENT, doc_type ENUM('DNI', 'CE', 'PASAPORTE', 'OTRO') DEFAULT 'DNI' NOT NULL, doc_number VARCHAR(20) NOT NULL, firstname VARCHAR(128) NOT NULL, last_name VARCHAR(128) NOT NULL, arrival datetime NOT NULL, departure datetime NOT NULL, company_id BIGINT, job_id BIGINT, location_id BIGINT NOT NULL, passenger_manifest_detail_id BIGINT, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX company_id_idx (company_id), INDEX job_id_idx (job_id), INDEX passenger_manifest_detail_id_idx (passenger_manifest_detail_id), INDEX location_id_idx (location_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE trip (id BIGINT AUTO_INCREMENT, vehicle_id BIGINT NOT NULL, origin_id BIGINT NOT NULL, departure_date DATE NOT NULL, arrival_date DATE, description VARCHAR(50) NOT NULL, notes VARCHAR(250), estimated_departure datetime, estimated_duration TIME, type ENUM('Aereo', 'Fluvial') NOT NULL, cost DECIMAL(18, 2), canceled TINYINT(1) DEFAULT '0' NOT NULL, closed TINYINT(1) DEFAULT '0' NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX vehicle_id_idx (vehicle_id), INDEX origin_id_idx (origin_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE user_account (id BIGINT AUTO_INCREMENT, sf_guard_user_id INT UNIQUE NOT NULL, firstname VARCHAR(64) NOT NULL, lastname VARCHAR(64), gender ENUM('Masculino', 'Femenino') NOT NULL, email VARCHAR(64) NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX sf_guard_user_id_idx (sf_guard_user_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE vehicle (id BIGINT AUTO_INCREMENT, company_id BIGINT NOT NULL, plate VARCHAR(20) NOT NULL, category ENUM('Aereo', 'Fluvial') NOT NULL, model_name VARCHAR(50) NOT NULL, hard_weight_limit BIGINT NOT NULL, safe_weight_limit BIGINT NOT NULL, max_passengers BIGINT, monthly_cost DECIMAL(18, 2) DEFAULT 0 NOT NULL, per_trip_cost DECIMAL(18, 2) DEFAULT 0, min_hours BIGINT, hourly_fuel_consumption DECIMAL(18, 2) DEFAULT 0 NOT NULL, contract_type ENUM('Encendido/Apagado', 'Tiempo en el Aire') DEFAULT 'Encendido/Apagado' NOT NULL, mobilization_cost DECIMAL(18, 2), demobilization_cost DECIMAL(18, 2), stepped_hourly_rates text, month_billable_time BIGINT DEFAULT 0 NOT NULL, is_active TINYINT(1) DEFAULT '1' NOT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX company_id_idx (company_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE vehicle_unavailability (id BIGINT AUTO_INCREMENT, vehicle_id BIGINT NOT NULL, start_date datetime NOT NULL, end_date datetime, observations text, INDEX vehicle_id_idx (vehicle_id), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE sf_guard_group (id INT AUTO_INCREMENT, name VARCHAR(255) UNIQUE, description TEXT, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE sf_guard_group_permission (group_id INT, permission_id INT, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(group_id, permission_id)) ENGINE = INNODB;
CREATE TABLE sf_guard_permission (id INT AUTO_INCREMENT, name VARCHAR(255) UNIQUE, description TEXT, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE sf_guard_remember_key (id INT AUTO_INCREMENT, user_id INT, remember_key VARCHAR(32), ip_address VARCHAR(50), created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX user_id_idx (user_id), PRIMARY KEY(id, ip_address)) ENGINE = INNODB;
CREATE TABLE sf_guard_user (id INT AUTO_INCREMENT, username VARCHAR(128) NOT NULL UNIQUE, algorithm VARCHAR(128) DEFAULT 'sha1' NOT NULL, salt VARCHAR(128), password VARCHAR(128), is_active TINYINT(1) DEFAULT '1', is_super_admin TINYINT(1) DEFAULT '0', last_login DATETIME, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, INDEX is_active_idx_idx (is_active), PRIMARY KEY(id)) ENGINE = INNODB;
CREATE TABLE sf_guard_user_group (user_id INT, group_id INT, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(user_id, group_id)) ENGINE = INNODB;
CREATE TABLE sf_guard_user_permission (user_id INT, permission_id INT, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(user_id, permission_id)) ENGINE = INNODB;
ALTER TABLE cargo_manifest_detail ADD CONSTRAINT cargo_manifest_detail_trip_id_trip_id FOREIGN KEY (trip_id) REFERENCES trip(id) ON DELETE CASCADE;
ALTER TABLE cargo_manifest_detail ADD CONSTRAINT cargo_manifest_detail_stretch_origin_id_stretch_id FOREIGN KEY (stretch_origin_id) REFERENCES stretch(id) ON DELETE CASCADE;
ALTER TABLE cargo_manifest_detail ADD CONSTRAINT cargo_manifest_detail_stretch_destination_id_stretch_id FOREIGN KEY (stretch_destination_id) REFERENCES stretch(id) ON DELETE CASCADE;
ALTER TABLE cargo_manifest_detail ADD CONSTRAINT cargo_manifest_detail_cost_center_id_cost_center_id FOREIGN KEY (cost_center_id) REFERENCES cost_center(id) ON DELETE CASCADE;
ALTER TABLE cargo_manifest_detail ADD CONSTRAINT cargo_manifest_detail_company_id_company_id FOREIGN KEY (company_id) REFERENCES company(id) ON DELETE CASCADE;
ALTER TABLE closed_stretch ADD CONSTRAINT closed_stretch_trip_id_trip_id FOREIGN KEY (trip_id) REFERENCES trip(id) ON DELETE CASCADE;
ALTER TABLE closed_stretch ADD CONSTRAINT closed_stretch_stretch_id_stretch_id FOREIGN KEY (stretch_id) REFERENCES stretch(id) ON DELETE CASCADE;
ALTER TABLE closed_stretch ADD CONSTRAINT closed_stretch_origin_id_location_id FOREIGN KEY (origin_id) REFERENCES location(id) ON DELETE CASCADE;
ALTER TABLE closed_stretch ADD CONSTRAINT closed_stretch_destination_id_location_id FOREIGN KEY (destination_id) REFERENCES location(id) ON DELETE CASCADE;
ALTER TABLE closed_stretch ADD CONSTRAINT closed_stretch_closed_trip_id_closed_trip_id FOREIGN KEY (closed_trip_id) REFERENCES closed_trip(id) ON DELETE CASCADE;
ALTER TABLE closed_trip ADD CONSTRAINT closed_trip_vehicle_id_vehicle_id FOREIGN KEY (vehicle_id) REFERENCES vehicle(id) ON DELETE CASCADE;
ALTER TABLE closed_trip ADD CONSTRAINT closed_trip_trip_id_trip_id FOREIGN KEY (trip_id) REFERENCES trip(id) ON DELETE CASCADE;
ALTER TABLE closed_trip ADD CONSTRAINT closed_trip_origin_id_location_id FOREIGN KEY (origin_id) REFERENCES location(id) ON DELETE CASCADE;
ALTER TABLE crewperson_manifest_detail ADD CONSTRAINT crewperson_manifest_detail_trip_id_trip_id FOREIGN KEY (trip_id) REFERENCES trip(id) ON DELETE CASCADE;
ALTER TABLE crewperson_manifest_detail ADD CONSTRAINT crewperson_manifest_detail_crewperson_id_person_id FOREIGN KEY (crewperson_id) REFERENCES person(id) ON DELETE CASCADE;
ALTER TABLE crewperson_manifest_detail ADD CONSTRAINT crewperson_manifest_detail_crew_position_id_crew_position_id FOREIGN KEY (crew_position_id) REFERENCES crew_position(id) ON DELETE CASCADE;
ALTER TABLE crewperson_manifest_detail ADD CONSTRAINT crewperson_manifest_detail_company_id_company_id FOREIGN KEY (company_id) REFERENCES company(id) ON DELETE CASCADE;
ALTER TABLE distance ADD CONSTRAINT distance_origin_id_location_id FOREIGN KEY (origin_id) REFERENCES location(id) ON DELETE CASCADE;
ALTER TABLE distance ADD CONSTRAINT distance_destination_id_location_id FOREIGN KEY (destination_id) REFERENCES location(id) ON DELETE CASCADE;
ALTER TABLE passenger_manifest_detail ADD CONSTRAINT passenger_manifest_detail_trip_id_trip_id FOREIGN KEY (trip_id) REFERENCES trip(id) ON DELETE CASCADE;
ALTER TABLE passenger_manifest_detail ADD CONSTRAINT passenger_manifest_detail_stretch_origin_id_stretch_id FOREIGN KEY (stretch_origin_id) REFERENCES stretch(id) ON DELETE CASCADE;
ALTER TABLE passenger_manifest_detail ADD CONSTRAINT passenger_manifest_detail_stretch_destination_id_stretch_id FOREIGN KEY (stretch_destination_id) REFERENCES stretch(id) ON DELETE CASCADE;
ALTER TABLE passenger_manifest_detail ADD CONSTRAINT passenger_manifest_detail_passenger_id_person_id FOREIGN KEY (passenger_id) REFERENCES person(id) ON DELETE CASCADE;
ALTER TABLE passenger_manifest_detail ADD CONSTRAINT passenger_manifest_detail_cost_center_id_cost_center_id FOREIGN KEY (cost_center_id) REFERENCES cost_center(id) ON DELETE CASCADE;
ALTER TABLE passenger_manifest_detail ADD CONSTRAINT passenger_manifest_detail_company_id_company_id FOREIGN KEY (company_id) REFERENCES company(id) ON DELETE CASCADE;
ALTER TABLE person ADD CONSTRAINT person_job_id_job_id FOREIGN KEY (job_id) REFERENCES job(id) ON DELETE CASCADE;
ALTER TABLE person ADD CONSTRAINT person_cost_center_id_cost_center_id FOREIGN KEY (cost_center_id) REFERENCES cost_center(id) ON DELETE CASCADE;
ALTER TABLE person ADD CONSTRAINT person_company_id_company_id FOREIGN KEY (company_id) REFERENCES company(id) ON DELETE CASCADE;
ALTER TABLE stretch ADD CONSTRAINT stretch_trip_id_trip_id FOREIGN KEY (trip_id) REFERENCES trip(id) ON DELETE CASCADE;
ALTER TABLE stretch ADD CONSTRAINT stretch_origin_id_location_id FOREIGN KEY (origin_id) REFERENCES location(id) ON DELETE CASCADE;
ALTER TABLE stretch ADD CONSTRAINT stretch_destination_id_location_id FOREIGN KEY (destination_id) REFERENCES location(id) ON DELETE CASCADE;
ALTER TABLE stretch_manifest_detail ADD CONSTRAINT stretch_manifest_detail_stretch_id_stretch_id FOREIGN KEY (stretch_id) REFERENCES stretch(id) ON DELETE CASCADE;
ALTER TABLE stretch_manifest_detail ADD CONSTRAINT sppi FOREIGN KEY (passenger_manifest_detail_id) REFERENCES passenger_manifest_detail(id) ON DELETE CASCADE;
ALTER TABLE stretch_manifest_detail ADD CONSTRAINT scci FOREIGN KEY (cargo_manifest_detail_id) REFERENCES cargo_manifest_detail(id) ON DELETE CASCADE;
ALTER TABLE tareo ADD CONSTRAINT tareo_passenger_manifest_detail_id_passenger_manifest_detail_id FOREIGN KEY (passenger_manifest_detail_id) REFERENCES passenger_manifest_detail(id) ON DELETE CASCADE;
ALTER TABLE tareo ADD CONSTRAINT tareo_location_id_location_id FOREIGN KEY (location_id) REFERENCES location(id) ON DELETE CASCADE;
ALTER TABLE tareo ADD CONSTRAINT tareo_job_id_job_id FOREIGN KEY (job_id) REFERENCES job(id) ON DELETE CASCADE;
ALTER TABLE tareo ADD CONSTRAINT tareo_company_id_company_id FOREIGN KEY (company_id) REFERENCES company(id) ON DELETE CASCADE;
ALTER TABLE trip ADD CONSTRAINT trip_vehicle_id_vehicle_id FOREIGN KEY (vehicle_id) REFERENCES vehicle(id) ON DELETE CASCADE;
ALTER TABLE trip ADD CONSTRAINT trip_origin_id_location_id FOREIGN KEY (origin_id) REFERENCES location(id) ON DELETE CASCADE;
ALTER TABLE user_account ADD CONSTRAINT user_account_sf_guard_user_id_sf_guard_user_id FOREIGN KEY (sf_guard_user_id) REFERENCES sf_guard_user(id) ON DELETE CASCADE;
ALTER TABLE vehicle ADD CONSTRAINT vehicle_company_id_company_id FOREIGN KEY (company_id) REFERENCES company(id) ON DELETE CASCADE;
ALTER TABLE vehicle_unavailability ADD CONSTRAINT vehicle_unavailability_vehicle_id_vehicle_id FOREIGN KEY (vehicle_id) REFERENCES vehicle(id) ON DELETE CASCADE;
ALTER TABLE sf_guard_group_permission ADD CONSTRAINT sf_guard_group_permission_permission_id_sf_guard_permission_id FOREIGN KEY (permission_id) REFERENCES sf_guard_permission(id) ON DELETE CASCADE;
ALTER TABLE sf_guard_group_permission ADD CONSTRAINT sf_guard_group_permission_group_id_sf_guard_group_id FOREIGN KEY (group_id) REFERENCES sf_guard_group(id) ON DELETE CASCADE;
ALTER TABLE sf_guard_remember_key ADD CONSTRAINT sf_guard_remember_key_user_id_sf_guard_user_id FOREIGN KEY (user_id) REFERENCES sf_guard_user(id) ON DELETE CASCADE;
ALTER TABLE sf_guard_user_group ADD CONSTRAINT sf_guard_user_group_user_id_sf_guard_user_id FOREIGN KEY (user_id) REFERENCES sf_guard_user(id) ON DELETE CASCADE;
ALTER TABLE sf_guard_user_group ADD CONSTRAINT sf_guard_user_group_group_id_sf_guard_group_id FOREIGN KEY (group_id) REFERENCES sf_guard_group(id) ON DELETE CASCADE;
ALTER TABLE sf_guard_user_permission ADD CONSTRAINT sf_guard_user_permission_user_id_sf_guard_user_id FOREIGN KEY (user_id) REFERENCES sf_guard_user(id) ON DELETE CASCADE;
ALTER TABLE sf_guard_user_permission ADD CONSTRAINT sf_guard_user_permission_permission_id_sf_guard_permission_id FOREIGN KEY (permission_id) REFERENCES sf_guard_permission(id) ON DELETE CASCADE;
