-- MySQL dump 10.11
--
-- Host: localhost    Database: perenco_dev
-- ------------------------------------------------------
-- Server version	5.0.83-0ubuntu3

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `cargo_manifest_detail`
--

DROP TABLE IF EXISTS `cargo_manifest_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cargo_manifest_detail` (
  `id` bigint(20) NOT NULL auto_increment,
  `trip_id` bigint(20) NOT NULL,
  `stretch_origin_id` bigint(20) NOT NULL,
  `stretch_destination_id` bigint(20) NOT NULL,
  `description` varchar(200) NOT NULL,
  `weight` decimal(18,2) NOT NULL,
  `cost_center_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `trip_id_idx` (`trip_id`),
  KEY `stretch_origin_id_idx` (`stretch_origin_id`),
  KEY `stretch_destination_id_idx` (`stretch_destination_id`),
  KEY `cost_center_id_idx` (`cost_center_id`),
  KEY `company_id_idx` (`company_id`),
  CONSTRAINT `cargo_manifest_detail_company_id_company_id` FOREIGN KEY (`company_id`) REFERENCES `company` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cargo_manifest_detail_cost_center_id_cost_center_id` FOREIGN KEY (`cost_center_id`) REFERENCES `cost_center` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cargo_manifest_detail_stretch_destination_id_stretch_id` FOREIGN KEY (`stretch_destination_id`) REFERENCES `stretch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cargo_manifest_detail_stretch_origin_id_stretch_id` FOREIGN KEY (`stretch_origin_id`) REFERENCES `stretch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cargo_manifest_detail_trip_id_trip_id` FOREIGN KEY (`trip_id`) REFERENCES `trip` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cargo_manifest_detail`
--

LOCK TABLES `cargo_manifest_detail` WRITE;
/*!40000 ALTER TABLE `cargo_manifest_detail` DISABLE KEYS */;
INSERT INTO `cargo_manifest_detail` VALUES (1,1,1,3,'petroleo','300.00',2,1),(2,1,1,2,'armamento','500.00',3,1);
/*!40000 ALTER TABLE `cargo_manifest_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `closed_stretch`
--

DROP TABLE IF EXISTS `closed_stretch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `closed_stretch` (
  `id` bigint(20) NOT NULL auto_increment,
  `trip_id` bigint(20) default NULL,
  `origin_id` bigint(20) default NULL,
  `destination_id` bigint(20) default NULL,
  `description` varchar(200) default NULL,
  `engine_start_time` datetime default NULL,
  `takeoff_time` datetime default NULL,
  `departure_time` datetime default NULL,
  `arrival_time` datetime default NULL,
  `landing_time` datetime default NULL,
  `engine_stop_time` datetime default NULL,
  `cargo_weight` decimal(18,2) default NULL,
  `passenger_weight` decimal(18,2) default NULL,
  `passenger_count` bigint(20) default '0',
  `fuel_recharge` tinyint(1) default '0',
  `load_type` enum('Carga externa','Carga interna','Pasajeros','Carga interna y pasajeros','Materiales de izaje') default NULL,
  `billable_gallons` decimal(18,2) default '0.00',
  `non_billable_gallons` decimal(18,2) default '0.00',
  `iquitos_gallons` decimal(18,2) default '0.00',
  `billable_time` decimal(18,2) default '0.00',
  `initial_billable_time` bigint(20) NOT NULL default '0',
  `assigned_billable_time` bigint(20) NOT NULL default '0',
  `stretch_id` bigint(20) default NULL,
  `closed_trip_id` bigint(20) default NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `trip_id_idx` (`trip_id`),
  KEY `origin_id_idx` (`origin_id`),
  KEY `destination_id_idx` (`destination_id`),
  KEY `stretch_id_idx` (`stretch_id`),
  KEY `closed_trip_id_idx` (`closed_trip_id`),
  CONSTRAINT `closed_stretch_closed_trip_id_closed_trip_id` FOREIGN KEY (`closed_trip_id`) REFERENCES `closed_trip` (`id`) ON DELETE CASCADE,
  CONSTRAINT `closed_stretch_destination_id_location_id` FOREIGN KEY (`destination_id`) REFERENCES `location` (`id`) ON DELETE CASCADE,
  CONSTRAINT `closed_stretch_origin_id_location_id` FOREIGN KEY (`origin_id`) REFERENCES `location` (`id`) ON DELETE CASCADE,
  CONSTRAINT `closed_stretch_stretch_id_stretch_id` FOREIGN KEY (`stretch_id`) REFERENCES `stretch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `closed_stretch_trip_id_trip_id` FOREIGN KEY (`trip_id`) REFERENCES `trip` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `closed_stretch`
--

LOCK TABLES `closed_stretch` WRITE;
/*!40000 ALTER TABLE `closed_stretch` DISABLE KEYS */;
/*!40000 ALTER TABLE `closed_stretch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `closed_trip`
--

DROP TABLE IF EXISTS `closed_trip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `closed_trip` (
  `id` bigint(20) NOT NULL auto_increment,
  `vehicle_id` bigint(20) NOT NULL,
  `origin_id` bigint(20) NOT NULL,
  `departure_date` date NOT NULL,
  `arrival_date` date default NULL,
  `description` varchar(50) NOT NULL,
  `notes` varchar(250) default NULL,
  `estimated_departure` datetime default NULL,
  `estimated_duration` time default NULL,
  `type` enum('Aereo','Fluvial') NOT NULL,
  `cost` decimal(18,2) default NULL,
  `canceled` tinyint(1) NOT NULL default '0',
  `closed` tinyint(1) NOT NULL default '0',
  `trip_id` bigint(20) default NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `vehicle_id_idx` (`vehicle_id`),
  KEY `origin_id_idx` (`origin_id`),
  KEY `trip_id_idx` (`trip_id`),
  CONSTRAINT `closed_trip_origin_id_location_id` FOREIGN KEY (`origin_id`) REFERENCES `location` (`id`) ON DELETE CASCADE,
  CONSTRAINT `closed_trip_trip_id_trip_id` FOREIGN KEY (`trip_id`) REFERENCES `trip` (`id`) ON DELETE CASCADE,
  CONSTRAINT `closed_trip_vehicle_id_vehicle_id` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicle` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `closed_trip`
--

LOCK TABLES `closed_trip` WRITE;
/*!40000 ALTER TABLE `closed_trip` DISABLE KEYS */;
/*!40000 ALTER TABLE `closed_trip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `company`
--

DROP TABLE IF EXISTS `company`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company` (
  `id` bigint(20) NOT NULL auto_increment,
  `ruc` varchar(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `is_active` tinyint(1) NOT NULL default '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ruc` (`ruc`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `company`
--

LOCK TABLES `company` WRITE;
/*!40000 ALTER TABLE `company` DISABLE KEYS */;
INSERT INTO `company` VALUES (1,'20222190909','Aureal S.A.C',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(2,'123456789','Perenco',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(3,'223456781','Petrex',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(4,'323456782','Helinka',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(5,'423456789','Petroworks',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(6,'523456781','HeliSelva',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(7,'623456782','Constructek',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(8,'836312124','Helisur',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(9,'837652297','Los Andes',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(10,'876209786','Fuerza Aerea Peruana (FAP)',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(11,'577158783','Columbia',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(12,'228765497','Aerolift',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(13,'874498362','Helimedical',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(14,'113076291','Aviaret',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(15,'097621983','Aeromaster',1,'2010-02-19 18:45:24','2010-02-19 18:45:24');
/*!40000 ALTER TABLE `company` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cost_center`
--

DROP TABLE IF EXISTS `cost_center`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cost_center` (
  `id` bigint(20) NOT NULL auto_increment,
  `name` varchar(128) NOT NULL,
  `is_active` tinyint(1) NOT NULL default '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cost_center`
--

LOCK TABLES `cost_center` WRITE;
/*!40000 ALTER TABLE `cost_center` DISABLE KEYS */;
INSERT INTO `cost_center` VALUES (1,'PP67F001-3-503',1,'2010-04-09 16:01:10','2010-04-09 16:52:53'),(2,'PP67F001-4-503',1,'2010-04-09 16:01:10','2010-04-09 16:53:00'),(3,'PP67F001-5-503',1,'2010-04-09 16:01:10','2010-04-09 16:53:07'),(4,'PP67F002-1-503',1,'2010-04-09 16:01:10','2010-04-09 16:53:18'),(5,'PP67F002-4-503',1,'2010-04-09 16:01:10','2010-04-09 16:53:29'),(6,'PU2ABC',1,'2010-04-09 16:01:10','2010-04-09 16:54:12'),(7,'PU2AGP',1,'2010-04-09 16:01:10','2010-04-09 16:54:21'),(8,'PU2AHS',1,'2010-04-09 16:01:10','2010-04-09 16:54:32'),(9,'PU2APM',1,'2010-04-09 16:01:10','2010-04-09 16:54:40');
/*!40000 ALTER TABLE `cost_center` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crew_position`
--

DROP TABLE IF EXISTS `crew_position`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crew_position` (
  `id` bigint(20) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL,
  `type` enum('Aereo','Fluvial') NOT NULL,
  `is_active` tinyint(1) NOT NULL default '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crew_position`
--

LOCK TABLES `crew_position` WRITE;
/*!40000 ALTER TABLE `crew_position` DISABLE KEYS */;
INSERT INTO `crew_position` VALUES (1,'Piloto','Aereo',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(2,'Copiloto','Aereo',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(3,'Tripulante','Aereo',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(4,'Tecnico','Aereo',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(5,'Ayudante','Fluvial',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(6,'Propietario','Fluvial',1,'2010-04-09 16:01:10','2010-04-09 16:01:10');
/*!40000 ALTER TABLE `crew_position` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `crewperson_manifest_detail`
--

DROP TABLE IF EXISTS `crewperson_manifest_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `crewperson_manifest_detail` (
  `id` bigint(20) NOT NULL auto_increment,
  `trip_id` bigint(20) NOT NULL,
  `crewperson_id` bigint(20) NOT NULL,
  `crew_position_id` bigint(20) NOT NULL,
  `weight` decimal(18,2) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `uses_passenger_seat` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `trip_id_idx` (`trip_id`),
  KEY `crewperson_id_idx` (`crewperson_id`),
  KEY `crew_position_id_idx` (`crew_position_id`),
  KEY `company_id_idx` (`company_id`),
  CONSTRAINT `crewperson_manifest_detail_company_id_company_id` FOREIGN KEY (`company_id`) REFERENCES `company` (`id`) ON DELETE CASCADE,
  CONSTRAINT `crewperson_manifest_detail_crewperson_id_person_id` FOREIGN KEY (`crewperson_id`) REFERENCES `person` (`id`) ON DELETE CASCADE,
  CONSTRAINT `crewperson_manifest_detail_crew_position_id_crew_position_id` FOREIGN KEY (`crew_position_id`) REFERENCES `crew_position` (`id`) ON DELETE CASCADE,
  CONSTRAINT `crewperson_manifest_detail_trip_id_trip_id` FOREIGN KEY (`trip_id`) REFERENCES `trip` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `crewperson_manifest_detail`
--

LOCK TABLES `crewperson_manifest_detail` WRITE;
/*!40000 ALTER TABLE `crewperson_manifest_detail` DISABLE KEYS */;
INSERT INTO `crewperson_manifest_detail` VALUES (1,1,1,1,'100.00',1,0),(2,1,2,2,'90.00',1,1);
/*!40000 ALTER TABLE `crewperson_manifest_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `distance`
--

DROP TABLE IF EXISTS `distance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `distance` (
  `id` bigint(20) NOT NULL auto_increment,
  `origin_id` bigint(20) NOT NULL,
  `destination_id` bigint(20) NOT NULL,
  `distance` decimal(18,2) NOT NULL,
  `is_active` tinyint(1) NOT NULL default '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `orig_dest_idx` (`origin_id`,`destination_id`),
  KEY `origin_id_idx` (`origin_id`),
  KEY `destination_id_idx` (`destination_id`),
  CONSTRAINT `distance_destination_id_location_id` FOREIGN KEY (`destination_id`) REFERENCES `location` (`id`) ON DELETE CASCADE,
  CONSTRAINT `distance_origin_id_location_id` FOREIGN KEY (`origin_id`) REFERENCES `location` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `distance`
--

LOCK TABLES `distance` WRITE;
/*!40000 ALTER TABLE `distance` DISABLE KEYS */;
INSERT INTO `distance` VALUES (1,1,2,'342.45',0,'2010-02-18 18:35:08','2010-04-09 16:10:07'),(2,2,12,'21.19',0,'2010-02-18 18:35:08','2010-04-09 16:14:04'),(3,2,3,'4.70',0,'2010-02-18 18:35:08','2010-04-09 16:21:47'),(4,2,13,'29.46',0,'2010-02-18 18:35:08','2010-04-09 16:17:03'),(5,3,7,'45.45',0,'2010-04-09 16:22:22','2010-04-09 16:22:22'),(6,3,13,'18.57',0,'2010-04-09 16:24:15','2010-04-09 16:24:15');
/*!40000 ALTER TABLE `distance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job`
--

DROP TABLE IF EXISTS `job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job` (
  `id` bigint(20) NOT NULL auto_increment,
  `name` varchar(64) NOT NULL,
  `is_active` tinyint(1) NOT NULL default '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `job`
--

LOCK TABLES `job` WRITE;
/*!40000 ALTER TABLE `job` DISABLE KEYS */;
INSERT INTO `job` VALUES (1,'CargoMaster',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(2,'Cocinero',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(3,'Ingeniero Sanitario',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(4,'Ingeniero Industrial',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(5,'Ingeniero Petrolero',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(6,'Tecnico Electricista',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(7,'Tecnico de Perforacion',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(8,'Asistente Administrativo',1,'2010-02-19 18:45:24','2010-02-19 18:45:24'),(9,'Consultor',1,'2010-02-19 18:45:24','2010-02-19 18:45:24');
/*!40000 ALTER TABLE `job` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `location`
--

DROP TABLE IF EXISTS `location`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `location` (
  `id` bigint(20) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `short_name` varchar(3) NOT NULL,
  `is_active` tinyint(1) NOT NULL default '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `location`
--

LOCK TABLES `location` WRITE;
/*!40000 ALTER TABLE `location` DISABLE KEYS */;
INSERT INTO `location` VALUES (1,'Iquitos','IQT',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(2,'LBC','LBC',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(3,'Paiche 1','PA1',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(4,'Paiche 2','PA2',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(5,'Paiche 3','PA3',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(6,'Paiche 4','PA4',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(7,'Pirana 1','PI1',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(8,'Pirana 2','PI2',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(9,'Pirana 3','PI3',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(10,'Pirana 4','PI4',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(11,'Dorado 1','DO1',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(12,'Dorado 2','DO2',1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(13,'Dorado 3','DO3',1,'2010-04-09 16:01:10','2010-04-09 16:15:43');
/*!40000 ALTER TABLE `location` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `passenger_manifest_detail`
--

DROP TABLE IF EXISTS `passenger_manifest_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `passenger_manifest_detail` (
  `id` bigint(20) NOT NULL auto_increment,
  `trip_id` bigint(20) NOT NULL,
  `stretch_origin_id` bigint(20) NOT NULL,
  `stretch_destination_id` bigint(20) NOT NULL,
  `passenger_id` bigint(20) NOT NULL,
  `weight` decimal(18,2) NOT NULL,
  `cost_center_id` bigint(20) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `trip_id_idx` (`trip_id`),
  KEY `stretch_origin_id_idx` (`stretch_origin_id`),
  KEY `stretch_destination_id_idx` (`stretch_destination_id`),
  KEY `cost_center_id_idx` (`cost_center_id`),
  KEY `passenger_id_idx` (`passenger_id`),
  KEY `company_id_idx` (`company_id`),
  CONSTRAINT `passenger_manifest_detail_company_id_company_id` FOREIGN KEY (`company_id`) REFERENCES `company` (`id`) ON DELETE CASCADE,
  CONSTRAINT `passenger_manifest_detail_cost_center_id_cost_center_id` FOREIGN KEY (`cost_center_id`) REFERENCES `cost_center` (`id`) ON DELETE CASCADE,
  CONSTRAINT `passenger_manifest_detail_passenger_id_person_id` FOREIGN KEY (`passenger_id`) REFERENCES `person` (`id`) ON DELETE CASCADE,
  CONSTRAINT `passenger_manifest_detail_stretch_destination_id_stretch_id` FOREIGN KEY (`stretch_destination_id`) REFERENCES `stretch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `passenger_manifest_detail_stretch_origin_id_stretch_id` FOREIGN KEY (`stretch_origin_id`) REFERENCES `stretch` (`id`) ON DELETE CASCADE,
  CONSTRAINT `passenger_manifest_detail_trip_id_trip_id` FOREIGN KEY (`trip_id`) REFERENCES `trip` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `passenger_manifest_detail`
--

LOCK TABLES `passenger_manifest_detail` WRITE;
/*!40000 ALTER TABLE `passenger_manifest_detail` DISABLE KEYS */;
INSERT INTO `passenger_manifest_detail` VALUES (1,1,1,2,1,'80.00',1,1),(2,1,1,3,2,'90.00',2,1),(3,5,5,5,1,'75.00',8,1),(4,5,5,5,3,'102.00',8,1),(5,5,5,5,4,'78.00',8,1),(6,5,5,5,5,'77.00',6,1),(7,5,5,5,6,'89.00',8,1),(8,5,5,5,10,'87.00',6,1),(9,5,5,5,9,'72.00',6,1),(10,5,5,5,8,'105.00',6,1),(11,5,5,5,7,'99.00',6,1);
/*!40000 ALTER TABLE `passenger_manifest_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `person`
--

DROP TABLE IF EXISTS `person`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `person` (
  `id` bigint(20) NOT NULL auto_increment,
  `doc_type` enum('DNI','CE','PASAPORTE','OTRO') NOT NULL,
  `doc_number` varchar(20) NOT NULL,
  `firstname` varchar(128) NOT NULL,
  `last_name` varchar(128) NOT NULL,
  `weight` decimal(18,2) NOT NULL,
  `company_id` bigint(20) NOT NULL,
  `job_id` bigint(20) NOT NULL,
  `cost_center_id` bigint(20) default NULL,
  `is_active` tinyint(1) NOT NULL default '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `company_id_idx` (`company_id`),
  KEY `job_id_idx` (`job_id`),
  KEY `cost_center_id_idx` (`cost_center_id`),
  CONSTRAINT `person_company_id_company_id` FOREIGN KEY (`company_id`) REFERENCES `company` (`id`) ON DELETE CASCADE,
  CONSTRAINT `person_cost_center_id_cost_center_id` FOREIGN KEY (`cost_center_id`) REFERENCES `cost_center` (`id`) ON DELETE CASCADE,
  CONSTRAINT `person_job_id_job_id` FOREIGN KEY (`job_id`) REFERENCES `job` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `person`
--

LOCK TABLES `person` WRITE;
/*!40000 ALTER TABLE `person` DISABLE KEYS */;
INSERT INTO `person` VALUES (1,'DNI','49827123','Juan','Perez','75.00',1,2,8,1,'2010-04-09 16:01:10','2010-04-12 10:59:29'),(2,'DNI','39827123','Maria','Martinez','65.00',3,1,8,1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(3,'CE','920','Breno','Colom Pacora','102.00',1,4,8,1,'2010-04-09 16:01:10','2010-04-12 10:57:57'),(4,'PASAPORTE','X23610','Luciana','Torres Villar','78.00',1,3,8,1,'2010-04-09 16:01:10','2010-04-12 10:59:29'),(5,'DNI','38456289','Eduardo','Gonzalez Sotomayor','77.00',1,6,6,1,'2010-04-09 16:01:10','2010-04-12 10:59:29'),(6,'DNI','38675411','Luis Alberto','Lopez Garrido','89.00',1,2,8,1,'2010-04-09 16:01:10','2010-04-12 10:59:29'),(7,'DNI','42676754','Marcos','Villarreal Ortiz','99.00',1,5,6,1,'2010-04-09 16:01:10','2010-04-12 10:59:29'),(8,'DNI','42009892','Luis','Zavala Carrera','105.00',1,1,6,1,'2010-04-09 16:01:10','2010-04-12 10:59:29'),(9,'DNI','41898921','Mario','Coronel Barrios','72.00',1,4,6,1,'2010-04-09 16:01:10','2010-04-12 10:59:29'),(10,'DNI','35092192','Alberto Javier','Rodriguez Aliaga','87.00',1,1,6,1,'2010-04-09 16:01:10','2010-04-12 10:59:29');
/*!40000 ALTER TABLE `person` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_group`
--

DROP TABLE IF EXISTS `sf_guard_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_group` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `description` text,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_group`
--

LOCK TABLES `sf_guard_group` WRITE;
/*!40000 ALTER TABLE `sf_guard_group` DISABLE KEYS */;
INSERT INTO `sf_guard_group` VALUES (1,'Jefes LogÃ­sticos','','2010-03-24 21:19:37','2010-03-24 21:20:49'),(2,'Asistentes logÃ­sticos','','2010-03-24 21:19:52','2010-03-24 21:20:40'),(3,'Radio operadores','','2010-03-24 21:20:59','2010-03-24 21:20:59'),(4,'Reportes','','2010-03-24 21:21:16','2010-03-24 21:21:16'),(5,'Contabilidad','','2010-03-24 21:21:32','2010-03-24 21:21:32'),(6,'admin','Administrator group','2010-04-09 16:01:10','2010-04-09 16:01:10');
/*!40000 ALTER TABLE `sf_guard_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_group_permission`
--

DROP TABLE IF EXISTS `sf_guard_group_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_group_permission` (
  `group_id` int(11) NOT NULL default '0',
  `permission_id` int(11) NOT NULL default '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`group_id`,`permission_id`),
  KEY `sf_guard_group_permission_permission_id_sf_guard_permission_id` (`permission_id`),
  CONSTRAINT `sf_guard_group_permission_group_id_sf_guard_group_id` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sf_guard_group_permission_permission_id_sf_guard_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_group_permission`
--

LOCK TABLES `sf_guard_group_permission` WRITE;
/*!40000 ALTER TABLE `sf_guard_group_permission` DISABLE KEYS */;
INSERT INTO `sf_guard_group_permission` VALUES (1,3,'2010-03-24 21:25:48','2010-03-24 21:25:48'),(1,4,'2010-03-24 21:22:54','2010-03-24 21:22:54'),(1,5,'2010-03-24 21:23:09','2010-03-24 21:23:09'),(1,6,'2010-03-24 21:23:16','2010-03-24 21:23:16'),(1,7,'2010-03-24 21:23:31','2010-03-24 21:23:31'),(1,8,'2010-03-24 21:23:40','2010-03-24 21:23:40'),(1,9,'2010-03-24 21:23:56','2010-03-24 21:23:56'),(1,10,'2010-03-24 21:24:02','2010-03-24 21:24:02'),(1,11,'2010-03-24 21:24:06','2010-03-24 21:24:06'),(1,12,'2010-03-24 21:24:26','2010-03-24 21:24:26'),(1,13,'2010-03-24 21:24:37','2010-03-24 21:24:37'),(1,14,'2010-03-24 21:24:46','2010-03-24 21:24:46'),(1,16,'2010-03-25 12:13:42','2010-03-25 12:13:42'),(2,3,'2010-03-24 21:25:56','2010-03-24 21:25:56'),(2,4,'2010-03-24 21:22:54','2010-03-24 21:22:54'),(2,5,'2010-03-24 21:23:09','2010-03-24 21:23:09'),(2,6,'2010-03-24 21:23:16','2010-03-24 21:23:16'),(2,7,'2010-03-24 21:23:31','2010-03-24 21:23:31'),(2,8,'2010-03-24 21:23:40','2010-03-24 21:23:40'),(2,10,'2010-03-24 21:24:02','2010-03-24 21:24:02'),(2,11,'2010-03-24 21:24:06','2010-03-24 21:24:06'),(2,12,'2010-03-24 21:24:26','2010-03-24 21:24:26'),(2,13,'2010-03-24 21:24:37','2010-03-24 21:24:37'),(2,14,'2010-03-24 21:24:46','2010-03-24 21:24:46'),(2,16,'2010-03-25 12:14:08','2010-03-25 12:14:08'),(3,10,'2010-03-24 21:26:03','2010-03-24 21:26:03'),(4,15,'2010-03-24 21:27:04','2010-03-24 21:27:04'),(5,8,'2010-03-24 21:23:40','2010-03-24 21:23:40'),(6,17,'2010-04-09 16:01:11','2010-04-09 16:01:11');
/*!40000 ALTER TABLE `sf_guard_group_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_permission`
--

DROP TABLE IF EXISTS `sf_guard_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_permission` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `description` text,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_permission`
--

LOCK TABLES `sf_guard_permission` WRITE;
/*!40000 ALTER TABLE `sf_guard_permission` DISABLE KEYS */;
INSERT INTO `sf_guard_permission` VALUES (1,'group','','2010-03-24 21:22:36','2010-03-24 21:22:36'),(2,'user_account','','2010-03-24 21:22:41','2010-03-24 21:22:41'),(3,'location','','2010-03-24 21:22:46','2010-03-24 21:22:46'),(4,'distance','','2010-03-24 21:22:54','2010-03-24 21:22:54'),(5,'company','','2010-03-24 21:23:09','2010-03-24 21:23:09'),(6,'person','','2010-03-24 21:23:16','2010-03-24 21:23:16'),(7,'vehicle','','2010-03-24 21:23:31','2010-03-24 21:23:31'),(8,'cost_center','','2010-03-24 21:23:40','2010-03-24 21:23:40'),(9,'trip_planning','','2010-03-24 21:23:56','2010-03-24 21:23:56'),(10,'radio_operator','','2010-03-24 21:24:02','2010-03-24 21:24:02'),(11,'fuel','','2010-03-24 21:24:06','2010-03-24 21:24:06'),(12,'manifest','','2010-03-24 21:24:26','2010-03-24 21:24:26'),(13,'people_location','','2010-03-24 21:24:37','2010-03-24 21:24:37'),(14,'trip_search','','2010-03-24 21:24:46','2010-03-24 21:24:46'),(15,'reports','','2010-03-24 21:26:53','2010-03-24 21:26:53'),(16,'unvailability','','2010-03-25 12:13:22','2010-03-25 12:13:22'),(17,'admin','Administrator permission','2010-04-09 16:01:10','2010-04-09 16:01:10'),(18,'crud','Permiso para acceder a los mantenedores','2010-04-09 16:01:10','2010-04-09 16:01:10');
/*!40000 ALTER TABLE `sf_guard_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_remember_key`
--

DROP TABLE IF EXISTS `sf_guard_remember_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_remember_key` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) default NULL,
  `remember_key` varchar(32) default NULL,
  `ip_address` varchar(50) NOT NULL default '',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`,`ip_address`),
  KEY `user_id_idx` (`user_id`),
  CONSTRAINT `sf_guard_remember_key_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_remember_key`
--

LOCK TABLES `sf_guard_remember_key` WRITE;
/*!40000 ALTER TABLE `sf_guard_remember_key` DISABLE KEYS */;
INSERT INTO `sf_guard_remember_key` VALUES (1,6,'766867dbb0a5a6ae071f52f573680154','127.0.0.1','2010-04-12 12:19:50','2010-04-12 12:19:50');
/*!40000 ALTER TABLE `sf_guard_remember_key` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_user`
--

DROP TABLE IF EXISTS `sf_guard_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_user` (
  `id` int(11) NOT NULL auto_increment,
  `username` varchar(128) NOT NULL,
  `algorithm` varchar(128) NOT NULL default 'sha1',
  `salt` varchar(128) default NULL,
  `password` varchar(128) default NULL,
  `is_active` tinyint(1) default '1',
  `is_super_admin` tinyint(1) default '0',
  `last_login` datetime default NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `is_active_idx_idx` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_user`
--

LOCK TABLES `sf_guard_user` WRITE;
/*!40000 ALTER TABLE `sf_guard_user` DISABLE KEYS */;
INSERT INTO `sf_guard_user` VALUES (1,'logistica_01_lbc','sha1','b23db56973dcbd916220b0a7361f996d','60adcbed857d659560d439ba3694119a61ac54dc',1,0,NULL,'2010-03-24 21:17:04','2010-03-24 21:17:04'),(2,'logistica_02_lbc','sha1','ed43d2fa3a0318d89f25b98f12487e33','23c571b595b2348f17c11d954ab75665342ba85e',1,0,NULL,'2010-03-24 21:17:32','2010-03-24 21:17:32'),(3,'radio_operador_lbc','sha1','ca351ec256eb9e2e48ef206363c50e3f','65c616976933c28e5a0024919deb8c1bff005038',1,0,NULL,'2010-03-24 21:18:06','2010-03-24 21:18:06'),(4,'reportes','sha1','f0f7fef1821272177064ca37706928b7','5fc79a9d5ab8f0eb147c67f84100fc2fd5114989',1,0,NULL,'2010-03-24 21:18:34','2010-03-24 21:18:34'),(5,'contabilidad','sha1','f0e431ede98c8b57d80d1f14fd203885','492c11a730986ddb60377b89c21d28f9323d750b',1,0,NULL,'2010-03-24 21:19:10','2010-03-24 21:19:10'),(6,'admin','sha1','13d5dfe5a26bf22cd6a7399895935e47','6b57cbda73645cbe7e4ba7fbc36152bae8389d83',1,1,'2010-04-12 14:35:01','2010-04-09 16:01:10','2010-04-12 14:35:01'),(7,'user1','sha1','1a0386f1ad0482da42544aad681a4e76','0c0153bcd78e12fca0caa35e8bebcce31a473ff0',1,0,NULL,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(8,'user2','sha1','0774647406c24cac216eed1bfb1643c8','308868c2fc7db12c8ba8101d396a73a43df053c4',1,0,NULL,'2010-04-09 16:01:10','2010-04-09 16:01:10');
/*!40000 ALTER TABLE `sf_guard_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_user_group`
--

DROP TABLE IF EXISTS `sf_guard_user_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_user_group` (
  `user_id` int(11) NOT NULL default '0',
  `group_id` int(11) NOT NULL default '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`user_id`,`group_id`),
  KEY `sf_guard_user_group_group_id_sf_guard_group_id` (`group_id`),
  CONSTRAINT `sf_guard_user_group_group_id_sf_guard_group_id` FOREIGN KEY (`group_id`) REFERENCES `sf_guard_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sf_guard_user_group_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_user_group`
--

LOCK TABLES `sf_guard_user_group` WRITE;
/*!40000 ALTER TABLE `sf_guard_user_group` DISABLE KEYS */;
INSERT INTO `sf_guard_user_group` VALUES (1,1,'2010-03-24 21:19:37','2010-03-24 21:19:37'),(1,4,'2010-03-24 21:21:16','2010-03-24 21:21:16'),(2,2,'2010-03-24 21:19:52','2010-03-24 21:19:52'),(3,3,'2010-03-24 21:20:59','2010-03-24 21:20:59'),(4,4,'2010-03-24 21:21:16','2010-03-24 21:21:16'),(5,5,'2010-03-24 21:21:32','2010-03-24 21:21:32'),(6,6,'2010-04-09 16:01:11','2010-04-09 16:01:11');
/*!40000 ALTER TABLE `sf_guard_user_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sf_guard_user_permission`
--

DROP TABLE IF EXISTS `sf_guard_user_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sf_guard_user_permission` (
  `user_id` int(11) NOT NULL default '0',
  `permission_id` int(11) NOT NULL default '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`user_id`,`permission_id`),
  KEY `sf_guard_user_permission_permission_id_sf_guard_permission_id` (`permission_id`),
  CONSTRAINT `sf_guard_user_permission_permission_id_sf_guard_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `sf_guard_permission` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sf_guard_user_permission_user_id_sf_guard_user_id` FOREIGN KEY (`user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sf_guard_user_permission`
--

LOCK TABLES `sf_guard_user_permission` WRITE;
/*!40000 ALTER TABLE `sf_guard_user_permission` DISABLE KEYS */;
INSERT INTO `sf_guard_user_permission` VALUES (7,18,'2010-04-09 16:01:11','2010-04-09 16:01:11');
/*!40000 ALTER TABLE `sf_guard_user_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stretch`
--

DROP TABLE IF EXISTS `stretch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stretch` (
  `id` bigint(20) NOT NULL auto_increment,
  `trip_id` bigint(20) default NULL,
  `origin_id` bigint(20) default NULL,
  `destination_id` bigint(20) default NULL,
  `description` varchar(200) default NULL,
  `engine_start_time` datetime default NULL,
  `takeoff_time` datetime default NULL,
  `departure_time` datetime default NULL,
  `arrival_time` datetime default NULL,
  `landing_time` datetime default NULL,
  `engine_stop_time` datetime default NULL,
  `cargo_weight` decimal(18,2) default NULL,
  `passenger_weight` decimal(18,2) default NULL,
  `passenger_count` bigint(20) default '0',
  `fuel_recharge` tinyint(1) default '0',
  `load_type` enum('Carga externa','Carga interna','Pasajeros','Carga interna y pasajeros','Materiales de izaje') default NULL,
  `billable_gallons` decimal(18,2) default '0.00',
  `non_billable_gallons` decimal(18,2) default '0.00',
  `iquitos_gallons` decimal(18,2) default '0.00',
  `billable_time` decimal(18,2) default '0.00',
  `initial_billable_time` bigint(20) NOT NULL default '0',
  `assigned_billable_time` bigint(20) NOT NULL default '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `trip_id_idx` (`trip_id`),
  KEY `origin_id_idx` (`origin_id`),
  KEY `destination_id_idx` (`destination_id`),
  CONSTRAINT `stretch_destination_id_location_id` FOREIGN KEY (`destination_id`) REFERENCES `location` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stretch_origin_id_location_id` FOREIGN KEY (`origin_id`) REFERENCES `location` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stretch_trip_id_trip_id` FOREIGN KEY (`trip_id`) REFERENCES `trip` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stretch`
--

LOCK TABLES `stretch` WRITE;
/*!40000 ALTER TABLE `stretch` DISABLE KEYS */;
INSERT INTO `stretch` VALUES (1,1,2,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'0.00','0.00','0.00','0.00',0,0,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(2,1,11,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'0.00','0.00','0.00','0.00',0,0,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(3,1,12,13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'0.00','0.00','0.00','0.00',0,0,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(4,1,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'0.00','0.00','0.00','0.00',0,0,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(5,5,1,2,'','2010-04-09 08:00:00','2010-04-09 08:10:00',NULL,NULL,'2010-04-09 09:52:00','2010-04-09 09:54:00',NULL,NULL,0,0,'Carga externa','0.00','0.00','0.00','114.00',0,342,'2010-04-09 17:01:10','2010-04-12 10:59:30'),(6,6,2,12,'','2010-04-09 10:39:00','2010-04-09 10:41:00',NULL,NULL,'2010-04-09 10:47:00',NULL,NULL,NULL,0,0,'Carga externa','0.00','0.00','0.00','8.00',0,0,'2010-04-09 17:01:54','2010-04-09 18:05:17'),(7,6,12,2,'',NULL,'2010-04-09 10:57:00',NULL,NULL,'2010-04-09 11:06:00',NULL,NULL,NULL,0,0,'Carga externa','0.00','0.00','0.00','9.00',8,0,'2010-04-09 17:01:54','2010-04-09 18:05:17'),(8,7,2,13,'',NULL,'2010-04-09 11:15:00',NULL,NULL,'2010-04-09 11:25:00',NULL,NULL,NULL,0,0,'Carga externa','0.00','0.00','0.00','10.00',0,0,'2010-04-09 17:02:29','2010-04-09 18:05:17'),(9,7,13,2,'',NULL,'2010-04-09 11:29:00',NULL,NULL,'2010-04-09 11:39:00','2010-04-09 11:41:00',NULL,NULL,0,0,'Carga externa','0.00','0.00','0.00','12.00',10,0,'2010-04-09 17:02:29','2010-04-09 18:05:17'),(10,8,2,3,'','2010-04-09 14:03:00','2010-04-09 14:05:00',NULL,NULL,'2010-04-09 14:08:00',NULL,NULL,NULL,0,0,'Carga externa','0.00','0.00','0.00','5.00',0,0,'2010-04-09 17:03:56','2010-04-09 18:05:17'),(11,8,3,7,'',NULL,'2010-04-09 14:16:00',NULL,NULL,'2010-04-09 14:30:00',NULL,NULL,NULL,0,0,'Carga externa','0.00','0.00','0.00','14.00',5,0,'2010-04-09 17:03:56','2010-04-09 18:05:17'),(12,8,7,13,'',NULL,'2010-04-09 14:33:00',NULL,NULL,'2010-04-09 14:38:00',NULL,NULL,NULL,0,0,'Carga externa','0.00','0.00','0.00','5.00',19,0,'2010-04-09 17:03:56','2010-04-09 18:05:17'),(13,8,13,2,'',NULL,'2010-04-09 14:42:00',NULL,NULL,'2010-04-09 14:53:00',NULL,NULL,NULL,0,0,'Carga externa','0.00','0.00','0.00','11.00',24,0,'2010-04-09 17:03:56','2010-04-09 18:05:17'),(14,9,2,1,'',NULL,'2010-04-09 15:10:00',NULL,NULL,'2010-04-09 16:52:00','2010-04-09 16:55:00',NULL,NULL,0,0,'Carga externa','0.00','0.00','0.00','105.00',0,0,'2010-04-09 17:04:33','2010-04-09 18:05:17');
/*!40000 ALTER TABLE `stretch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stretch_manifest_detail`
--

DROP TABLE IF EXISTS `stretch_manifest_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stretch_manifest_detail` (
  `id` bigint(20) NOT NULL auto_increment,
  `stretch_id` bigint(20) default NULL,
  `passenger_manifest_detail_id` bigint(20) default NULL,
  `cargo_manifest_detail_id` bigint(20) default NULL,
  `type` enum('passenger','cargo') NOT NULL,
  `weight_x_distance` decimal(18,2) NOT NULL default '0.00',
  `minutes` decimal(18,2) NOT NULL,
  `monetary_value` decimal(18,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`),
  KEY `stretch_id_idx` (`stretch_id`),
  KEY `passenger_manifest_detail_id_idx` (`passenger_manifest_detail_id`),
  KEY `cargo_manifest_detail_id_idx` (`cargo_manifest_detail_id`),
  CONSTRAINT `scci` FOREIGN KEY (`cargo_manifest_detail_id`) REFERENCES `cargo_manifest_detail` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sppi` FOREIGN KEY (`passenger_manifest_detail_id`) REFERENCES `passenger_manifest_detail` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stretch_manifest_detail_stretch_id_stretch_id` FOREIGN KEY (`stretch_id`) REFERENCES `stretch` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stretch_manifest_detail`
--

LOCK TABLES `stretch_manifest_detail` WRITE;
/*!40000 ALTER TABLE `stretch_manifest_detail` DISABLE KEYS */;
INSERT INTO `stretch_manifest_detail` VALUES (15,5,3,NULL,'passenger','25683.75','10.91','145.41'),(16,5,4,NULL,'passenger','34929.90','14.83','197.76'),(17,5,5,NULL,'passenger','26711.10','11.34','151.22'),(18,5,6,NULL,'passenger','26368.65','11.20','149.29'),(19,5,7,NULL,'passenger','30478.05','12.94','172.55'),(20,5,8,NULL,'passenger','29793.15','12.65','168.67'),(21,5,9,NULL,'passenger','24656.40','10.47','139.59'),(22,5,10,NULL,'passenger','35957.25','15.27','203.57'),(23,5,11,NULL,'passenger','33902.55','14.40','191.94');
/*!40000 ALTER TABLE `stretch_manifest_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tareo`
--

DROP TABLE IF EXISTS `tareo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tareo` (
  `id` bigint(20) NOT NULL auto_increment,
  `doc_type` enum('DNI','CE','PASAPORTE','OTRO') NOT NULL default 'DNI',
  `doc_number` varchar(20) NOT NULL,
  `firstname` varchar(128) NOT NULL,
  `last_name` varchar(128) NOT NULL,
  `arrival` datetime NOT NULL,
  `departure` datetime NOT NULL,
  `company_id` bigint(20) default NULL,
  `job_id` bigint(20) default NULL,
  `location_id` bigint(20) NOT NULL,
  `passenger_manifest_detail_id` bigint(20) default NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `company_id_idx` (`company_id`),
  KEY `job_id_idx` (`job_id`),
  KEY `passenger_manifest_detail_id_idx` (`passenger_manifest_detail_id`),
  KEY `location_id_idx` (`location_id`),
  CONSTRAINT `tareo_company_id_company_id` FOREIGN KEY (`company_id`) REFERENCES `company` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tareo_job_id_job_id` FOREIGN KEY (`job_id`) REFERENCES `job` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tareo_location_id_location_id` FOREIGN KEY (`location_id`) REFERENCES `location` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tareo_passenger_manifest_detail_id_passenger_manifest_detail_id` FOREIGN KEY (`passenger_manifest_detail_id`) REFERENCES `passenger_manifest_detail` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tareo`
--

LOCK TABLES `tareo` WRITE;
/*!40000 ALTER TABLE `tareo` DISABLE KEYS */;
/*!40000 ALTER TABLE `tareo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trip`
--

DROP TABLE IF EXISTS `trip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `trip` (
  `id` bigint(20) NOT NULL auto_increment,
  `vehicle_id` bigint(20) NOT NULL,
  `origin_id` bigint(20) NOT NULL,
  `departure_date` date NOT NULL,
  `arrival_date` date default NULL,
  `description` varchar(50) NOT NULL,
  `notes` varchar(250) default NULL,
  `estimated_departure` datetime default NULL,
  `estimated_duration` time default NULL,
  `type` enum('Aereo','Fluvial') NOT NULL,
  `cost` decimal(18,2) default NULL,
  `canceled` tinyint(1) NOT NULL default '0',
  `closed` tinyint(1) NOT NULL default '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `vehicle_id_idx` (`vehicle_id`),
  KEY `origin_id_idx` (`origin_id`),
  CONSTRAINT `trip_origin_id_location_id` FOREIGN KEY (`origin_id`) REFERENCES `location` (`id`) ON DELETE CASCADE,
  CONSTRAINT `trip_vehicle_id_vehicle_id` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicle` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trip`
--

LOCK TABLES `trip` WRITE;
/*!40000 ALTER TABLE `trip` DISABLE KEYS */;
INSERT INTO `trip` VALUES (1,1,2,'2010-02-18','2010-02-18','Trasteos LBC - PiraÃ±a 1',NULL,NULL,NULL,'Aereo','0.00',0,0,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(2,3,2,'2010-02-18','2010-02-18','Trasteos LBC - PiraÃ±a 1',NULL,NULL,NULL,'Aereo','0.00',0,0,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(3,3,2,'2010-02-18','2010-02-18','Trasteos LBC - Paiche 3',NULL,NULL,NULL,'Aereo','0.00',0,0,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(4,4,2,'2010-02-18','2010-02-18','Trasteos LBC - Dorado 1',NULL,NULL,NULL,'Aereo','0.00',0,0,'2010-02-18 18:35:09','2010-02-18 18:35:09'),(5,8,1,'2010-04-09','2010-04-09','Vuelo Nro. 1 de 09/04/2010','','2010-04-09 00:00:00','00:00:00','Aereo','0.00',0,0,'2010-04-09 17:00:55','2010-04-09 17:01:10'),(6,7,2,'2010-04-09','2010-04-09','Vuelo Nro. 2 del 09/04/2010','','2010-04-09 00:00:00','00:00:00','Aereo','0.00',0,0,'2010-04-09 17:01:38','2010-04-09 17:01:54'),(7,7,2,'2010-04-09','2010-04-09','Vuelo Nro. 3 de 09/04/2010','','2010-04-09 00:00:00','00:00:00','Aereo','0.00',0,0,'2010-04-09 17:02:21','2010-04-09 17:02:29'),(8,6,2,'2010-04-09','2010-04-09','Vuelo Nro. 4 de 09/04/2010','','2010-04-09 00:00:00','00:00:00','Aereo','0.00',0,0,'2010-04-09 17:03:10','2010-04-09 17:03:56'),(9,8,2,'2010-04-09','2010-04-09','Vuelo Nro. 5 de 09/04/2010','','2010-04-09 00:00:00','00:00:00','Aereo','0.00',0,0,'2010-04-09 17:04:28','2010-04-09 17:04:33');
/*!40000 ALTER TABLE `trip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_account`
--

DROP TABLE IF EXISTS `user_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_account` (
  `id` bigint(20) NOT NULL auto_increment,
  `sf_guard_user_id` int(11) NOT NULL,
  `firstname` varchar(64) NOT NULL,
  `lastname` varchar(64) default NULL,
  `gender` enum('Masculino','Femenino') NOT NULL,
  `email` varchar(64) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `sf_guard_user_id` (`sf_guard_user_id`),
  KEY `sf_guard_user_id_idx` (`sf_guard_user_id`),
  CONSTRAINT `user_account_sf_guard_user_id_sf_guard_user_id` FOREIGN KEY (`sf_guard_user_id`) REFERENCES `sf_guard_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_account`
--

LOCK TABLES `user_account` WRITE;
/*!40000 ALTER TABLE `user_account` DISABLE KEYS */;
INSERT INTO `user_account` VALUES (1,1,'Logistica 1','LBC','Masculino','logistica_01_lbc.plm@mailinator.com','2010-03-24 21:17:04','2010-03-24 21:17:04'),(2,2,'Logistica 2','LBC','Masculino','logistica_02_lbc.plm@mailinator.com','2010-03-24 21:17:32','2010-03-24 21:17:32'),(3,3,'Radio Operador','LBC','Masculino','radio_operador_lbc.plm@mailinator.com','2010-03-24 21:18:06','2010-03-24 21:18:06'),(4,4,'Usuario','Reportes','Masculino','reportes.plm@mailinator.com','2010-03-24 21:18:34','2010-03-24 21:18:34'),(5,5,'Usuario','Contabilidad','Masculino','contabilidad.plm@mailinator.com','2010-03-24 21:19:11','2010-03-24 21:19:11');
/*!40000 ALTER TABLE `user_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vehicle`
--

DROP TABLE IF EXISTS `vehicle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vehicle` (
  `id` bigint(20) NOT NULL auto_increment,
  `company_id` bigint(20) NOT NULL,
  `plate` varchar(20) NOT NULL,
  `category` enum('Aereo','Fluvial') NOT NULL,
  `model_name` varchar(50) NOT NULL,
  `hard_weight_limit` bigint(20) NOT NULL,
  `safe_weight_limit` bigint(20) NOT NULL,
  `max_passengers` bigint(20) default NULL,
  `monthly_cost` decimal(18,2) NOT NULL default '0.00',
  `per_trip_cost` decimal(18,2) default '0.00',
  `min_hours` bigint(20) default NULL,
  `hourly_fuel_consumption` decimal(18,2) NOT NULL default '0.00',
  `contract_type` enum('Encendido/Apagado','Tiempo en el Aire') NOT NULL default 'Encendido/Apagado',
  `mobilization_cost` decimal(18,2) default NULL,
  `demobilization_cost` decimal(18,2) default NULL,
  `stepped_hourly_rates` text,
  `month_billable_time` bigint(20) NOT NULL default '0',
  `is_active` tinyint(1) NOT NULL default '1',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `company_id_idx` (`company_id`),
  CONSTRAINT `vehicle_company_id_company_id` FOREIGN KEY (`company_id`) REFERENCES `company` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vehicle`
--

LOCK TABLES `vehicle` WRITE;
/*!40000 ALTER TABLE `vehicle` DISABLE KEYS */;
INSERT INTO `vehicle` VALUES (1,1,'AGC316','Aereo','AVATEC',3000,2000,20,'0.00','0.00',NULL,'170.00','Encendido/Apagado',NULL,NULL,NULL,0,1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(2,1,'AGC318','Fluvial','AVATEC',3000,2000,20,'0.00','0.00',NULL,'100.00','Encendido/Apagado',NULL,NULL,NULL,0,1,'2010-04-09 16:01:10','2010-04-09 16:01:10'),(3,4,'XYZ-121','Aereo','Kamov',20,4000,10,'292800.00','0.00',NULL,'200.00','Encendido/Apagado','274600.00','84000.00','0, 2800\n120, 3190\n',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(4,4,'XYZ-122','Aereo','Kamov',6000,4000,10,'0.00','0.00',3,'150.00','Encendido/Apagado','25000.00',NULL,'0, 6100\n',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(5,4,'XYZ-123','Aereo','MI8',6000,4000,10,'60000.00','0.00',40,'210.00','Encendido/Apagado','7000.00','7000.00','0, 1000\n41, 2500\n61, 2400\n',2415,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(6,8,'XYZ-124','Aereo','MI17',6000,4000,10,'0.00','0.00',10,'210.00','Encendido/Apagado',NULL,NULL,'0, 4550',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(7,8,'XYZ-125','Aereo','Bell 212',6000,4000,10,'0.00','0.00',NULL,'100.00','Encendido/Apagado',NULL,NULL,'0, 2350\n',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(8,9,'XYZ-126','Aereo','Twin Otter',6000,4000,10,'167500.00','0.00',NULL,'100.00','Encendido/Apagado','125000.00','65000.00','0, 800\n',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(9,10,'XYZ-127','Aereo','Twin Otter',6000,4000,10,'0.00','3900.00',NULL,'100.00','Encendido/Apagado',NULL,NULL,NULL,0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(10,4,'XYZ-128','Aereo','Sikorsky S61N',6000,4000,10,'240800.00','0.00',NULL,'170.00','Encendido/Apagado','201600.00','84000.00','0, 2400\n121, 2400\n',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(11,11,'XYZ-129','Aereo','Chinook',6000,4000,10,'387971.00','0.00',NULL,'410.00','Encendido/Apagado','500000.00',NULL,'0, 5148\n',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(12,12,'XYZ-130','Aereo','MI8 T',6000,4000,10,'0.00','0.00',40,'210.00','Encendido/Apagado',NULL,NULL,'0, 3200\n',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(13,13,'XYZ-131','Aereo','Bolkow',6000,4000,10,'110239.57','0.00',NULL,'100.00','Encendido/Apagado','50000.00',NULL,'0, 2600\n',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(14,14,'XYZ-132','Aereo','MI8 T',6000,4000,10,'0.00','0.00',40,'210.00','Encendido/Apagado',NULL,NULL,'0, 2990\n',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08'),(15,15,'XYZ-133','Aereo','Sikorsky S61N',6000,4000,10,'295000.00','0.00',NULL,'170.00','Encendido/Apagado',NULL,NULL,'0, 2750\n',0,1,'2010-02-18 18:35:08','2010-02-18 18:35:08');
/*!40000 ALTER TABLE `vehicle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vehicle_unavailability`
--

DROP TABLE IF EXISTS `vehicle_unavailability`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vehicle_unavailability` (
  `id` bigint(20) NOT NULL auto_increment,
  `vehicle_id` bigint(20) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime default NULL,
  `observations` text,
  PRIMARY KEY  (`id`),
  KEY `vehicle_id_idx` (`vehicle_id`),
  CONSTRAINT `vehicle_unavailability_vehicle_id_vehicle_id` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicle` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vehicle_unavailability`
--

LOCK TABLES `vehicle_unavailability` WRITE;
/*!40000 ALTER TABLE `vehicle_unavailability` DISABLE KEYS */;
INSERT INTO `vehicle_unavailability` VALUES (1,1,'2010-02-02 00:00:00','2010-10-10 00:00:00','mantenimiento'),(2,2,'2010-02-02 00:00:00','2010-10-10 00:00:00','mantenimiento');
/*!40000 ALTER TABLE `vehicle_unavailability` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2010-04-12 15:02:53
