<?php

/**
 * user_account actions.
 *
 * @package    PLM
 * @subpackage user_account
 * @author     Aureal_Systems
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class user_accountActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->user_accounts = Doctrine::getTable('UserAccount')
      ->createQuery('a')
      ->execute();
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->form = new UserAccountForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new UserAccountForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($user_account = Doctrine::getTable('UserAccount')->find(array($request->getParameter('id'))), sprintf('Object user_account does not exist (%s).', $request->getParameter('id')));
    $this->form = new UserAccountForm($user_account);
    $this->form->setDefault('username', $user_account->getSfGuardUser()->getUsername());
    $this->form->setDefault('is_active', $user_account->getSfGuardUser()->getIsActive());
    $this->user_account = $user_account;
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($user_account = Doctrine::getTable('UserAccount')->find(array($request->getParameter('id'))), sprintf('Object user_account does not exist (%s).', $request->getParameter('id')));
    $this->form = new UserAccountForm($user_account);

    $this->processForm($request, $this->form);
    $this->user_account = $user_account;
    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $request->checkCSRFProtection();
    $this->forward404Unless($user_account = Doctrine::getTable('UserAccount')->find(array($request->getParameter('id'))), sprintf('Object user_account does not exist (%s).', $request->getParameter('id')));
    $sf_guard_user = $user_account->getSfGuardUser();
    $user_account->delete();
    $sf_guard_user->delete();

    $this->redirect('@user_account');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $form_values = $form->getValues();
      if (is_null($form_values['id'])) {
        $sf_guard_user = new sfGuardUser();
        $sf_guard_user->username = $form_values['username'];
        $sf_guard_user->setPassword($form_values['new_password']);
        $sf_guard_user->is_active = $form_values['is_active'];
        $sf_guard_user->save();
        $new_obj = new UserAccount();
        $new_obj->sf_guard_user_id = $sf_guard_user->getId();
        $new_obj->firstname = $form_values['firstname'];
        $new_obj->lastname = $form_values['lastname'];
        $new_obj->email = $form_values['email'];
        $new_obj->gender = $form_values['gender'];
        $new_obj->save();
      } else {
        $user_account = $form->save();
        $sf_guard_user = $user_account->getSfGuardUser();
        $sf_guard_user->username = $form_values['username'];
        $sf_guard_user->is_active = $form_values['is_active'];
        if (strlen(trim($form_values['new_password']))>0) {
            $sf_guard_user->setPassword($form_values['new_password']);
        }
        $sf_guard_user->save();
      }
      $this->redirect('@user_account');

    }
  }
}
