<!-- JS deps -->
<?php use_javascript('ui.js') ?>

<!-- datePicker -->
<?php use_javascript('ui.datepicker.js') ?>
<?php use_stylesheet('ui-lightness/jquery-ui-1.8rc1.custom.css') ?>

<!-- timePicker -->
<?php use_stylesheet('ui.timepickr.css') ?>
<?php use_javascript('jquery.utils.js') ?>
<?php use_javascript('jquery.strings.js') ?>
<?php use_javascript('ui.dropslide.js') ?>
<?php use_javascript('ui.timepickr-0.3.js') ?>

<!-- local -->
<?php use_stylesheet('vehicle_unavailability_search.css'); ?>
<?php use_javascript('vehicle_unavailability_search.js'); ?>

<?php use_javascript('ui.core.js') ?>
<?php use_stylesheet('ui-lightness/jquery-ui-1.8rc1.custom.css') ?>

<?php slot('username',$username); ?>
<?php slot('breadCrumbs',Helper::makeBreadCrumbs(array(
        array('text' => 'Vehiculos', 'link' => url_for('@vehicle')), array('text' => 'Indisponibilidad')
))); ?>

<div id="main">
    <h2>Indisponibilidad de vehículos</h2>

    <?php use_stylesheets_for_form($form) ?>
    <?php use_javascripts_for_form($form) ?>

    <form class="clear" id="unavailability_form" action="<?php echo url_for('@unavailability') ?>" method="get" <?php $form->isMultipart() and print 'enctype="multipart/form-data" ' ?>>
        <ul class="divided horizontal_form">
            <?php echo $form->renderGlobalErrors() ?>
            <?php echo $form->renderHiddenFields(false) ?>
            <li><?php echo $form['aux_start_date']->renderLabel() ?><br />
                <?php echo $form['aux_start_date'] ?>
                <?php echo $form['aux_start_date']->renderError() ?>
                <?php echo $form['aux_start_time'] ?>
                <img border="0" id="trigger-start-time" alt="Time" src="/images/clock.png">
                <?php echo $form['aux_start_time']->renderError() ?>
            </li>
            <li class="hspacer">&nbsp;</li>
            <li><?php echo $form['aux_end_date']->renderLabel() ?><br />
                <?php echo $form['aux_end_date'] ?>
                <?php echo $form['aux_end_date']->renderError() ?>
                <?php echo $form['aux_end_time'] ?>
                <img border="0" id="trigger-end-time" alt="Time" src="/images/clock.png">
                <?php echo $form['aux_end_time']->renderError() ?>
            </li>
            <li class="hspacer">&nbsp;</li>
            <li><br><input type="submit" value="Buscar" /></li>
        </ul>
    </form>


        <ul class="vertical_form clear">
            <li>
                <table class="data" border="1" cellspacing="0" cellpadding="0">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Vehiculo</th>
                            <th>Inicio</th>
                            <th>Fin</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $odd = true; ?>
                        <?php foreach ($vehicle_unavailabilities as $vehicle_unavailability) { ?>
                        <tr <?php if ($odd) { ?> class="odd"<?php } ?>>
                            <td><?php echo $vehicle_unavailability->getId() ?></td>
                            <td><?php echo $vehicle_unavailability->getVehicle() ?></td>
                            <td><?php echo $vehicle_unavailability->getStartDate() ?></td>
                            <td><?php echo $vehicle_unavailability->getEndDate() ?></td>
                            <td>
                                    <?php echo link_to('Editar', 'unavailability/edit?id='.$vehicle_unavailability->getId()) ?>
                                    <?php echo link_to('Eliminar', 'unavailability/delete?id='.$vehicle_unavailability->getId(), array('method' => 'delete', 'confirm' => '¿Está seguro?')); ?>
                            </td>
                        </tr>
                            <?php $odd = !$odd; ?>
                            <?php } ?>
                    </tbody>
                </table>
            </li>
            <li><a href="<?php echo url_for('@unavailability_new') ?>">Nueva</a></li>
        </ul>

</div>



<?php if (0) { ?>
<h1>Vehicle unavailabilitys List</h1>

<table>
    <thead>
        <tr>
            <th>Id</th>
            <th>Vehicle</th>
            <th>Start date</th>
            <th>End date</th>
            <th>Observations</th>
        </tr>
    </thead>
    <tbody>
            <?php foreach ($vehicle_unavailabilitys as $vehicle_unavailability): ?>
        <tr>
            <td><a href="<?php echo url_for('unavailability/edit?id='.$vehicle_unavailability->getId()) ?>"><?php echo $vehicle_unavailability->getId() ?></a></td>
            <td><?php echo $vehicle_unavailability->getVehicleId() ?></td>
            <td><?php echo $vehicle_unavailability->getStartDate() ?></td>
            <td><?php echo $vehicle_unavailability->getEndDate() ?></td>
            <td><?php echo $vehicle_unavailability->getObservations() ?></td>
        </tr>
            <?php endforeach; ?>
    </tbody>
</table>

<a href="<?php echo url_for('unavailability/new') ?>">New</a>
    <? } ?>
