<!-- datePicker -->
<?php use_javascript('ui.core.js') ?>
<?php use_javascript('ui.datepicker.js') ?>
<?php use_stylesheet('ui-lightness/jquery-ui-1.8rc1.custom.css') ?>

<?php use_javascript('trip_planning.js') ?>
<?php use_stylesheet('trip_planning.css') ?>

<?php slot('userName',$userName); ?>
<?php slot('breadCrumbs',Helper::makeBreadCrumbs(array(
        array('link' => url_for('@fligths'), 'text' => 'Viajes'),
        array('text' => $date)
))); ?>

<input type="hidden" id="route2fligths" value="<?php echo url_for('@fligths'); ?>" />

<div id="main">

    <div id="create_trip_fields">
        <h2>Programación de viajes</h2>
        <ul class="divided vertical_form">
            <li>
                <label for="date_flight">Seleccionar fecha:</label><br />
                <input type="text" id="dtpDate" value="<?php echo $date; ?>" />
            </li>
            <form id="createTripForm" action="<?php echo url_for('trip_planning/create') ?>" method="POST">
                <?=$createTripForm->renderGlobalErrors()?>
                <?=$createTripForm->renderHiddenFields()?>
                <li>
                    <table class="data" border="0" cellspacing="0" cellpadding="0">
                        <tr class="odd">
                            <th><?=$createTripForm['Vehicle']->renderLabel()?></th>
                            <td>
                                <?=$createTripForm['Vehicle']->renderError()?>
                                <?=$createTripForm['Vehicle']->renderHelp()?>
                                <?=$createTripForm['Vehicle']->render()?>
                            </td>
                        </tr>
                        <tr>
                            <th><?=$createTripForm['Origin']->renderLabel()?></th>
                            <td>
                                <?=$createTripForm['Origin']->renderError()?>
                                <?=$createTripForm['Origin']->renderHelp()?>
                                <?=$createTripForm['Origin']->render()?>
                            </td>
                        </tr>
                        <tr class="odd">
                            <th><?=$createTripForm['Description']->renderLabel()?></th>
                            <td>
                                <?=$createTripForm['Description']->renderError()?>
                                <?=$createTripForm['Description']->renderHelp()?>
                                <?=$createTripForm['Description']->render()?>
                            </td>
                        </tr>
                    </table>
                </li>
                <li>
                    <input type="submit" value="Crear Viaje" />
                    <?php if( $ntrips && !$isClosedTripPlanning ){ ?>
                        <?=button_to(
                                'Cerrar Programación',
                                '@closeTripPlanning?'.
                                'day='  .substr($date,0,2).'&'.
                                'month='.substr($date,3,2).'&'.
                                'year=' .substr($date,6,6),
                                'confirm=¿Está seguro que desea cerrar la programación de viajes?'
                        )?>
                    <?php }else{ ?>
                        <input type="button" value="Cerrar programación" disabled />
                    <?php } ?>
                    <?php echo button_to('Salir', '@dashboard') ?>
                </li>
            </form>
        </ul>
    </div>

    <div id="trip_list">
        <h2>Viajes programados para <?php echo $date; ?></h2>


        <div class="clear">
        <ul class="divided vertical_form">
            <?php if($isClosedTripPlanning) { ?>
            <li>
                <ul class="warning_list">
                    <li>Está cerrada la programación de viajes para <?=$date==date('d/m/Y')?'hoy':$date?></li>
                </ul>
            </li>
            <?php } ?>
            <li>
                <?php if(!$vehicles->count()) { ?>
                <ul class="info_list">
                    <li>No hay viajes para <?=$date==date('d/m/Y')?'hoy':$date?></li>
                </ul>
                <?php }else{ ?>
                <ul class="info_list">
                    <li>Hay <?=$ntrips?> viaje(s) para <?=$date==date('d/m/Y')?'hoy':$date?></li>
                </ul>
                <?php } ?>
            </li>
        </ul>
        </div>        

        <div class="clear">
        <?php foreach ($vehicles as $vehicle) { ?>
            <h4><?=$vehicle->model_name?> (<?=$vehicle->plate?>)</h4>
            <table class="data" border="0" cellspacing="0" cellpadding="0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Descripción</th>
                        <th>Mangas</th>
                        <th>Editar</th>
                        <!--<th>Borrar</th>-->
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="4">Un total de <?=count($vehicle->Trips)?> viaje(s)</th>
                    </tr>
                </tfoot>
                <tbody>
                    <?php $i=1; ?>
                    <?php foreach($vehicle->Trips as $Trip) { ?>
                    <tr<?=$i%2==0?'class="odd"':''?>>
                        <td><?=$i?></td>
                        <td><?=$Trip->description?></td>
                        <td><?=count($Trip->Stretches)?></td>
                        <td><?php echo link_to(image_tag('edit',array('border'=>'0')),'@fligth?id='.$Trip->id); ?></td>
                        <!--<td><?php // echo link_to(image_tag('delete.gif',array('border'=>'0')),'@fligths'); ?></td>-->
                    </tr>
                    <?php $i++; ?>
                    <?php } ?>
                </tbody>
            </table>
        <?php } ?>
        </div>

    </div>    
</div>
