<?php

define("DESCRIPTION_MAX_LEGTH", 30);

class editTripForm extends BaseForm {

    static public $pattern;
    
    public function configure() {

        // Regex patter for EstimatedDuration validator
        self::$pattern  = '/^';
        self::$pattern .= '((?P<days>0?[1-9]|[12][0-9]|3|[0-4])[ ]*d ?)?';
        self::$pattern .= '((?P<hours>[01]?[0-9]|2[0-3])[ ]*h ?)?';
        self::$pattern .= '((?P<minutes>0?[0-9]|[1-5]?[0-9])[ ]*m?)?';
        self::$pattern .= '$/';

        $this->setWidgets(array(
                'Description' => new sfWidgetFormInputText(array(),array('maxlength'=>DESCRIPTION_MAX_LEGTH)),
                'EstimatedHour' => new sfWidgetFormTime(),
                'EstimatedDuration' => new sfWidgetFormInputText(array(),array('size'=>'9')),
                'Notes' => new sfWidgetFormTextarea(),
                'Stretches' => new sfWidgetFormInputHidden()
        ));

        $this->setValidators(array(
                'Description' => new sfValidatorString(
                        array(
                            'max_length' => DESCRIPTION_MAX_LEGTH
                        ),
                        array(
                            'required' => 'Debe ingresar una breve descripción',
                            'max_length' => '"%value%" es demasiado largo (Máximo %max_length% caracteres).',
                            'min_length' => '"%value%" es demasiado corto (Mínimo %min_length% caracteres).'
                        )
                ),
                'EstimatedHour' => new sfValidatorTime(array('required' => false)),
                'EstimatedDuration' => new sfValidatorRegex(
                        array(
                            'required' => false,
                            'pattern' => self::$pattern
                        ),
                        array(
                            'invalid' => 'El formato correcto es: 1d 2h 3m'
                        )
                ),
                'Notes' => new sfValidatorString(array('max_length' => 150,'required'=>false)),
                'Stretches' => new sfValidatorString(array('required'=>false))
        ));

        $this->widgetSchema->setNameFormat('createTripForm[%s]');
        
        $this->widgetSchema->setLabels(array(
                'Description'      =>  'Descripción',
                'EstimatedHour'    =>  'Hora estimada',
                'EstimatedDuration'=>  'Duración estimada',
                'Notes'            =>  'Observaciones'
        ));
        $this->widgetSchema->setHelps(array(
                'EstimatedDuration'=>  'Formato: 1d 2h 3m',
        ));

    }

}
?>