<?php

/**
 * trip_planning actions.
 *
 * @package    PLM
 * @subpackage trip_planning
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class trip_planningActions extends sfActions {

    /**
     * Executes index action.
     * This action render the main view of 'Trip planning' and have three parts:
     *   1) Pick date form.
     *   2) Add Trip form.
     *   3) Trips for date selected list.
     * This action is associated to template indexSuccess.php
     * @param sfRequest $request A request object
     */
    public function executeIndex(sfWebRequest $request) {
        $this->createTripForm = new createTripForm();
        $this->prepareIndex($request);
    }


    /**
     * Retrieves username, url date, vehicles list
     * @param sfWebRequest $request the request object from index or create 
     * action
     */
    private function prepareIndex(sfWebRequest $request){
        $this->userName = $this->getUser()->getUsername();
        $this->date = $request->getParameter("day") != "" ?
                $request->getParameter("day") . '/' .
                        $request->getParameter("month") . '/' .
                        $request->getParameter("year") :
                date("d/m/Y");
        $date_db = Helper::swapDateFormat($this->date,'-');
        $this->isClosedTripPlanning = TripTable::isClosedTripPlanning($date_db);
        $this->vehicles = Doctrine_Query::create()
                ->from('Vehicle v')
                ->leftJoin('v.Trips t')
                ->where('t.departure_date = ?', $date_db )
                //->andWhere('v.is_active = ?',1)
                ->execute();
        $this->ntrips = Doctrine_Query::create()
                ->from('Trip t')
                ->where('t.departure_date = ?', $date_db )
                ->count();
    }


    /**
     * Executes create action.
     * This action:recibe
     *   1) Proccess data posted from create trip form
     *   2) Validate the form data
     *   3) Save the Trip
     *   4) Redirect to edit action.
     * @param sfRequest $request A request object
     */
    public function executeCreate(sfWebRequest $request) {
        $this->createTripForm = new createTripForm();
        $this->createTripForm->bind($request->getParameter(
				    $this->createTripForm->getName()));
        if ($this->createTripForm->isValid()) {
            $fromTrip = $this->createTripForm->getValues();
            $trip = new Trip();
            $trip->link('Vehicle', $fromTrip['Vehicle']);
            $trip->link('Origin', $fromTrip['Origin']);
            $trip->description = $fromTrip['Description'];
            $trip->type = 'Aereo';
            $trip->cost = 0;
            $trip->departure_date = $fromTrip['Date'];
            $trip->arrival_date = $fromTrip['Date'];
            $trip->save();
            $this->redirect('trip_planning/edit?id='.$trip->getId());
        }
        $this->prepareIndex($request);
        $this->setTemplate('index');
    }

    /**
     * Executes edit action.
     * This action is a wrapper of prepareEdit();
     * This action is associated to template editSuccess.php
     * @param sfRequest $request A request object
     */
    public function executeEdit(sfWebRequest $request) {
        $this->prepareEdit($request,true);
    }


    /**
     * Retrieves username, url date, vehicles list
     * This action:
     *   1) Gets the id Trip parameter (by URL)
     *   2) Gets the trip object
     *   3) Gets all Locations (for the 'Obicaciones' combo in template)
     *   4) Create the edit Trip form with some default values (saved in the
     *      prev. form)
     * @param sfWebRequest $request the request object from index or create 
     * action
     */
    private function prepareEdit(sfWebRequest $request,$create_form){
        $this->userName = $this->getUser()->getUsername();
        $this->id = $request->getParameter("id");
        $this->trip = Doctrine_Core::getTable('Trip')->find($this->id);
        $this->editable = $this->trip->hasEditableStretches();
        $this->locations = Doctrine_Core::getTable('Location')->findBy('is_active', 1);
        if($this->trip->estimated_duration){
            $estim_depart = Trip::renderDuration($this->trip
						 ->estimated_duration);
        }else{
            $estim_depart = $this->trip->estimated_duration;
        }

        if($create_form){
            $this->editTripForm = new editTripForm(array(
                'Description' => $this->trip->description,
                'EstimatedHour' => $this->trip->estimated_departure,
                'EstimatedDuration' => $estim_depart,
                'Notes' => $this->trip->notes,
                'Stretches' => implode(',',$this->trip->getDestinationsIds())
            ));
        }

    }


    /**
     * Executes createStretch action.
     * This action:
     *   1) Create Edit Trip form (for binding and validating)
     *   2) Update the trip object and save
     *   3) Parse the hidden field 'Stretches' and create stretches
     *   4) Redirect to index
     * @param sfRequest $request A request object
     */
    public function executeCreateStretch(sfWebRequest $request) {

        $this->editTripForm = new editTripForm();
        $this->editTripForm->bind($request->getParameter($this->editTripForm
							 ->getName()));
        if($this->editTripForm->isValid()) {
            $fromEditTrip = $this->editTripForm->getValues();
            $trip = Doctrine_Core::getTable('Trip')->find($request
							  ->getParameter("id"));
            $trip->description = $fromEditTrip['Description'];
            $trip->notes = $fromEditTrip['Notes'];
            $trip->estimated_departure  = $trip->departure_date . ' ';
            $trip->estimated_departure .= $fromEditTrip['EstimatedHour'];
            $trip->estimated_duration = Trip::parseDuration(
					   $fromEditTrip['EstimatedDuration']);
            $trip->save();

            $fligths_given_date =   '@fligths_given_date?'.
                                    'year=' .substr($trip->departure_date,0,4).'&'.
                                    'month='.substr($trip->departure_date,5,2).'&'.
                                    'day='  .substr($trip->departure_date,8,2);

            if($fromEditTrip['Stretches']!=''){
                $stretches_from_form = explode(',', $fromEditTrip['Stretches']);
            }else{
                $stretches_from_form = array();
            }
            
            if($trip->hasEditableStretches() && 
	       !$trip->hasThisDestinations($stretches_from_form)){
	      foreach($trip->Stretches as $stretch){
		$stretch->delete();
	      }

              // prepend origin of trip to destinations array
              array_unshift($stretches_from_form, $trip->Origin->id );

	      for($i = 0; $i < count($stretches_from_form) - 1; $i++) {
		$stretch = new Stretch();
		$stretch->link('Origin', $stretches_from_form[$i]);
		$stretch->link('Destination', $stretches_from_form[$i+1]);
		$stretch->link('Trip', $trip->id);
		$stretch->save();
	      }
            }
            $this->redirect($fligths_given_date);
            //$this->redirect('trip_planning/index');
            //$this->redirect('trip_planning/edit?id='.$trip->getId());
        }
        $this->prepareEdit($request,false);
        $this->setTemplate('edit');

    }


    /**
     * Flags a trip as canceled
     */
    public function executeCancelTrip(sfWebRequest $request){
        //TODO: hay un método en symfony que te redirecciona a una página 404 si no encuentra el id
        // redirect404Unless...
        $trip = Doctrine_Core::getTable('Trip')->find($request->getParameter("id"));
        $trip->canceled = true;
        $trip->save();
        $this->redirect('trip_planning/edit?id='.$trip->id);
    }

    /**
     * Close Trip Planning means:
     *   1) Flag as closed each trip which departure date is = given date
     *   2) Copy those trips and their stretches to another tables, and link them to the original
     * @param sfWebRequest $request
     */
    public function executeCloseTripPlanning(sfWebRequest $request){

        $date = $request->getParameter("year").'-'.
                $request->getParameter("month").'-'.
                $request->getParameter("day");

        TripTable::closeTripPlanning($date);

        $fligths_given_date =   '@fligths_given_date?'.
                                'year=' .$request->getParameter("year").'&'.
                                'month='.$request->getParameter("month").'&'.
                                'day='  .$request->getParameter("day");

        $this->redirect($fligths_given_date);
    }

}
