<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/

/**
 * Description of distributionOfCostCenterByCompanyQuery
 */
class distributionOfCostCenterByCompanyQuery implements PLMReport {

    public static function execute($formValues) {

        $rows = Doctrine_Query::create()
                ->select(
                        'pmd.id,'.
                        'smd.id,'.
                        'cc.id as ccid,'.
                        'sum(smd.minutes) as minutes,'.
                        'cc.name as ccname,'.
                        't.departure_date,'.
                        'c.id as cid,'.
                        'c.name as cname,'.
                        't.departure_date as day'
                )
                ->from('StretchManifestDetail smd')
                ->innerJoin('smd.PassengerManifestDetail pmd')
                ->innerJoin('pmd.Trip t')
                ->innerJoin('pmd.Company c')
                ->innerJoin('t.Vehicle v')
                ->innerJoin('pmd.CostCenter cc')
                ->where('t.departure_date >= ?', $formValues['StartDate'] )
                ->andWhere('t.departure_date <= ?', $formValues['EndDate'] )
                ->groupBy('pmd.cost_center_id, t.departure_date, pmd.company_id')
                ->orderBy('c.id, cc.id, t.departure_date')
                ;

        if(!empty($formValues['Company'])) {
            $rows->andWhere('pmd.company_id = ? ',$formValues['Company']);
        }

        //  query executing and retrieving an array
        $rows = $rows->fetchArray();

        // calc total
        $total = 0;
        foreach($rows as $row){
            $total += $row['minutes'];
        }

        // companies array
        foreach($rows as $row){
            $companies[$row['cid']] = $row['cname'];
        }

        // rows2
        foreach($rows as $row){
            $rows2[$row['cid']][] = $row;
        }

        // rows2
        $rows3 = array();
        foreach($rows2 as $key => $value){

            $rows3[$key] = array();

            foreach($value as $v){

                //if(!isset($rows3[$key]['cost_centers']) ) {$rows3[$key]['cost_centers'] = array();}
                //if(!isset($rows3[$key]['cost_centers'][$v['ccid']]) ) {$rows3[$key]['cost_centers'][$v['ccid']] = array();}
                if(!isset($rows3[$key]['cost_centers'][$v['ccid']]['minutes']) ) {$rows3[$key]['cost_centers'][$v['ccid']]['minutes'] = '';}
                
                if($rows3[$key]['cost_centers'][$v['ccid']]['minutes']=="" || $rows3[$key]['cost_centers'][$v['ccid']]['minutes'] ==0 ){
                    $rows3[$key]['cost_centers'][$v['ccid']]['minutes'] = $v['minutes'];
                }else{
                    $rows3[$key]['cost_centers'][$v['ccid']]['minutes'] += $v['minutes'];
                }


            if(!isset($rows3[$key]['minutes']) ) {$rows3[$key]['minutes'] = '';}
                if($rows3[$key]['minutes']=="" || $rows3[$key]['minutes'] == 0 ){
                    $rows3[$key]['minutes'] = $v['minutes'];
                }else{
                    $rows3[$key]['minutes'] += $v['minutes'];
                }


                
                $rows3[$key]['cost_centers'][$v['ccid']]['ccname'] = $v['ccname'];
                $rows3[$key]['cost_centers'][$v['ccid']]['days'][$v['day']] = $v['minutes'];

            }

            
            
            //$rows3[$key]['minutes'] = 100;
            $rows3[$key]['company_name'] = $v['cname'];
        }

        // diference between startDate and endDate
        $ndays = (strtotime($formValues['EndDate']) - strtotime($formValues['StartDate']))/(60*60*24)+1 ;

        for($i=0;$i<$ndays;$i++){
            $days[] = date('Y-m-d',strtotime('+'.$i.' day',strtotime($formValues['StartDate'])));

        }


        return array(
            $rows,
            $rows2,
            $rows3,
            $total,
            $companies,
            $days
        );

        
    }

}
?>
