<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
*/

/**
 * Description of distributionOfCostCenterByCompanyQuery
 *
 */
class consolidatedHoursCostAndFuelByCostCenterQuery implements PLMReport {


    public static function execute($formValues) {

        $rows = Doctrine_Query::create()
                ->select(
                        'pmd.id,'.
                        'smd.id,'.
                        'cc.id as ccid,'.
                        'sum(smd.minutes) as minutes,'.
                        'sum(smd.monetary_value) as monetary_value,'.
                        'cc.name as ccname,'.
                        't.departure_date as departure_date'
                )
                ->from('StretchManifestDetail smd')
                ->innerJoin('smd.PassengerManifestDetail pmd')
                ->innerJoin('pmd.Trip t')
                ->innerJoin('t.Vehicle v')
                ->innerJoin('pmd.CostCenter cc')
                ->where('t.departure_date >= ?', $formValues['StartDate'] )
                ->andWhere('t.departure_date <= ?', $formValues['EndDate'] )
                ->groupBy('pmd.cost_center_id, t.departure_date')
                ->orderBy('cc.id, t.departure_date')
                ;

        if(!empty($formValues['Vehicle'])) {
            $rows->andWhere('t.vehicle_id = ? ',$formValues['Vehicle']);
        }

        if(!empty($formValues['CostCenter'])) {
            $rows->andWhere('pmd.cost_center_id = ? ',$formValues['CostCenter']);
        }

        //  query executing and retrieving an array
        $rows = $rows->fetchArray();

        // diference between startDate and endDate
        $ndays = (strtotime($formValues['EndDate']) - strtotime($formValues['StartDate']))/(60*60*24)+1 ;

        for($i=0;$i<$ndays;$i++){
            $days[] = date('Y-m-d',strtotime('+'.$i.' day',strtotime($formValues['StartDate'])));
        }

        $data = array();
        $data['cost_centers'] = array();
        $data['dates'] = array();
        $data['totals'] = array(
            'minutes' => 0.00,
            'costs'   => 0.00,
            'fuel '   => 0.00
        );

        foreach($rows as $row) {
            /* Accumulate for totals */
            $data['totals']['minutes'] += $row['minutes'];
            $data['totals']['costs'] += $row['monetary_value'];
            /* FIXME: Add JP1 fuel support here */
            if (!array_key_exists($row['ccid'], $data['cost_centers'])) {
                $data['cost_centers'][$row['ccid']] = array(
                    'name' => $row['ccname'],
                    'dates' => array(),
                    'subtotals' => array(
                        'minutes' => 0.00,
                        'costs'   => 0.00,
                        'fuel '   => 0.00
                    )
                );
                $data['cost_centers'][$row['ccid']]['dates'][$row['departure_date']] = array(
                    'minutes' => $row['minutes'],
                    'monetary_value' => $row['monetary_value'],
                    'fuel' => 0.00 /* FIXME: Put real values */
                );
                $data['cost_centers'][$row['ccid']]['subtotals']['minutes'] += $row['minutes'];
                $data['cost_centers'][$row['ccid']]['subtotals']['costs'] += $row['monetary_value'];
                //$data['cost_centers'][$row['ccid']]['subtotals']['fuel'] += 0.0; /* FIXME */

            }
            if (!array_key_exists($row['departure_date'], $data['dates'])) {
                $data['dates'][$row['departure_date']] = array(
                    'minutes' => 0.00,
                    'costs'   => 0.00,
                    'fuel '   => 0.00
                );
                $data['dates'][$row['departure_date']]['minutes'] += $row['minutes'];
                $data['dates'][$row['departure_date']]['costs'] += $row['monetary_value'];
                // $data['dates'][$row['departure_date']]['fuel'] += 0.0; /* FIXME */
            }
        }

        return array($data,$days);
        
    }

}

?>
