<?php

class peopleLocationForm extends BaseForm {

    public function configure() {

        
        $this->setWidgets(array(
                'SearchString' => new sfWidgetFormInputText(array(),array('size'=>'15')),
                'StartDate' => new sfWidgetFormInputText(array(),array('size'=>'10')),
                'EndDate' => new sfWidgetFormInputText(array(),array('size'=>'10'))
        ));

        // Translating to spanish the fields labels
        $this->widgetSchema->setLabels(array(
                'SearchString'=>'Buscar',
                'StartDate'=>'Fecha inicial',
                'EndDate'=>'Fecha final'
        ));

        // Setting validators to each field
        $this->setValidators(array(
            'SearchString' => new sfValidatorString(
                array('required'=>false),
                array()
            ),
            'StartDate' => new sfValidatorDate(
                array(
                    'date_format' => '@(?P<day>\d{2}).(?P<month>\d{2}).(?P<year>\d{4})@ ',
                    'date_output' => 'Y-m-d'
                ),
                array(
                    'required' => '<u>'.$this->getWidget('StartDate')->getLabel().'</u>: Este campo es obligatorio',
                    'invalid' => '<u>'.$this->getWidget('StartDate')->getLabel().'</u>: Fecha Inválida',
                    'bad_format'  => '<u>'.$this->getWidget('StartDate')->getLabel().'</u>: El formato de la fecha es (dd/mm/aaaa)'
                )
            ),
            'EndDate' => new sfValidatorDate(
                array(
                    'date_format' => '@(?P<day>\d{2}).(?P<month>\d{2}).(?P<year>\d{4})@ ',
                    'date_output' => 'Y-m-d'
                ),
                array(
                    'required' => '<u>'.$this->getWidget('EndDate')->getLabel().'</u>: Este campo es obligatorio',
                    'invalid' => '<u>'.$this->getWidget('EndDate')->getLabel().'</u>: Fecha Inválida',
                    'bad_format' => '<u>'.$this->getWidget('EndDate')->getLabel().'</u>: El formato de la fecha es (dd/mm/aaaa)'
                )
            )

        ));

        $this->validatorSchema->setPostValidator(
            new sfValidatorSchemaCompare(
                'StartDate',
                sfValidatorSchemaCompare::LESS_THAN_EQUAL,
                'EndDate',
                array('throw_global_error' => true),
                array('invalid' => 
                    'La <u>'.$this->getWidget('StartDate')->getLabel().'</u> ("%left_field%")'.
                    ' debe ser menor que '.
                    'la <u>'.$this->getWidget('EndDate')->getLabel().'</u> ("%right_field%")'
                )
            )
        );



        $this->widgetSchema->setNameFormat('reportPeopleLocation[%s]');

    }


}
?>