<?php

class consolidatedTripsByVehicleForm extends BaseForm {

    protected static $vehicles;
    protected static $costCenters;

    public function configure() {

        self::$vehicles[''] = "--- [TODOS] ---";
        foreach (Doctrine::getTable('Vehicle')->findBy('is_active', 1) as $vehicle ) {
            self::$vehicles[$vehicle->id] = $vehicle->model_name."($vehicle->plate)";
        }
        
        self::$costCenters[''] = "--- [TODOS] ---";
        foreach (Doctrine::getTable('CostCenter')->findBy('is_active', 1) as $cc ) {
            self::$costCenters[$cc->id] = $cc->name;
        }
        
        $this->setWidgets(array(
                'Vehicle' => new sfWidgetFormSelect(array('choices' =>self::$vehicles )),
                'CostCenter' => new sfWidgetFormSelect(array('choices' =>self::$costCenters )),
                'StartDate' => new sfWidgetFormInputText(array(),array('size'=>'10')),
                'EndDate' => new sfWidgetFormInputText(array(),array('size'=>'10'))
        ));

        $valid_vehicles = array_keys(array_slice(self::$vehicles,1,count(self::$vehicles)-1,true));
        $valid_costCenters = array_keys(array_slice(self::$costCenters,1,count(self::$costCenters)-1,true));
        
        // Translating to spanish the fields labels
        $this->widgetSchema->setLabels(array(
                'Vehicle'=>'Vehículo',
                'CostCenter'=>'Centro de Costo',
                'StartDate'=>'Fecha inicial',
                'EndDate'=>'Fecha final'
        ));

        // Setting validators to each field
        $this->setValidators(array(
            'Vehicle' => new sfValidatorChoice(
                array(
                    'required' => false ,
                    'choices' => $valid_vehicles
                ),
                array(
                    'required' => '<u>'.$this->getWidget('Vehicle')->getLabel().'</u>: Debe seleccionar un Vehículo',
                    'invalid' => '<u>'.$this->getWidget('Vehicle')->getLabel().'</u>: Inválido'
                )
            ),
            'CostCenter' => new sfValidatorChoice(
                array(
                    'required' => false,
                    'choices' => $valid_costCenters
                ),
                array(
                    'required' => '<u>'.$this->getWidget('CostCenter')->getLabel().'</u>: Debe seleccionar un Centro de Costo',
                    'invalid' => '<u>'.$this->getWidget('CostCenter')->getLabel().'</u>: Inválido'
                )
            ),
            'StartDate' => new sfValidatorDate(
                array(
                    'date_format' => '@(?P<day>\d{2}).(?P<month>\d{2}).(?P<year>\d{4})@ ',
                    'date_output' => 'Y-m-d'
                ),
                array(
                    'required' => '<u>'.$this->getWidget('StartDate')->getLabel().'</u>: Este campo es obligatorio',
                    'invalid' => '<u>'.$this->getWidget('StartDate')->getLabel().'</u>: Fecha Inválida',
                    'bad_format'  => '<u>'.$this->getWidget('StartDate')->getLabel().'</u>: El formato de la fecha es (dd/mm/aaaa)'
                )
            ),
            'EndDate' => new sfValidatorDate(
                array(
                    'date_format' => '@(?P<day>\d{2}).(?P<month>\d{2}).(?P<year>\d{4})@ ',
                    'date_output' => 'Y-m-d'
                ),
                array(
                    'required' => '<u>'.$this->getWidget('EndDate')->getLabel().'</u>: Este campo es obligatorio',
                    'invalid' => '<u>'.$this->getWidget('EndDate')->getLabel().'</u>: Fecha Inválida',
                    'bad_format' => '<u>'.$this->getWidget('EndDate')->getLabel().'</u>: El formato de la fecha es (dd/mm/aaaa)'
                )
            )
        ));

        $this->validatorSchema->setPostValidator(
            new sfValidatorSchemaCompare(
                'StartDate',
                sfValidatorSchemaCompare::LESS_THAN_EQUAL,
                'EndDate',
                array('throw_global_error' => true),
                array('invalid' =>
                    'La <u>'.$this->getWidget('StartDate')->getLabel().'</u> ("%left_field%")'.
                    ' debe ser menor que '.
                    'la <u>'.$this->getWidget('EndDate')->getLabel().'</u> ("%right_field%")'
                )
            )
        );


        $this->widgetSchema->setNameFormat('reportConsolidatedTripsByVehicle[%s]');

    }


}
?>