<?php

class SearchTareoForm extends BaseForm {

    protected static $companies;
    protected static $jobs;
    protected static $locations;

    public function configure() {

        // Filling an array with all Companies
        self::$companies[''] = "--- Seleccione la Empresa ---";
        foreach (Doctrine::getTable('Company')->findAll() as $company ) {
            self::$companies[$company->id] = $company;
        }
        // Filling an array with all Jobs
        self::$jobs[''] = "--- Seleccione el Puesto ---";
        foreach (Doctrine::getTable('Job')->findAll() as $job ) {
            self::$jobs[$job->id] = $job;
        }
        // Filling an array with all Locations
        self::$locations[''] = "--- Seleccione la Ubicación ---";
        foreach (Doctrine::getTable('Location')->findAll() as $location ) {
            self::$locations[$location->id] = $location;
        }

        // Removing the first element of each array
        $valid_companies = array_keys(array_slice(self::$companies,1,count(self::$companies)-1,true));
        $valid_jobs = array_keys(array_slice(self::$jobs,1,count(self::$jobs)-1,true));
        $valid_locations = array_keys(array_slice(self::$locations,1,count(self::$locations)-1,true));

        // Setting widgets to each field
        $this->setWidgets(array(
                'Date' => new sfWidgetFormInputText(array(),array('size'=>'10')),
                'Company' => new sfWidgetFormSelect(array('choices' =>self::$companies )),
                'Job' => new sfWidgetFormSelect(array('choices' =>self::$jobs )),
                'Location' => new sfWidgetFormSelect(array('choices' =>self::$locations ))
        ));

        // Setting validators to each field
        $this->setValidators(array(
            'Date' => new sfValidatorDate(
                array(
                        'required' => false,
                        'date_format' => '@(?P<day>\d{2}).(?P<month>\d{2}).(?P<year>\d{4})@ ',
                        'date_output' => 'Y-m-d'
                ),
                array(
                        'invalid' => 'Fecha Inválida',
                        'bad_format'  => 'El formato de la fecha es (dd/mm/aaaa)'
                )
            ),
            'Company' => new sfValidatorChoice(array(
                'choices' => $valid_companies,
                'required'=>false )),
            'Job' => new sfValidatorChoice(array(
                'choices' => $valid_jobs,
                'required'=>false)),
            'Location' => new sfValidatorChoice(array(
                'choices' => $valid_locations,
                'required'=>false))
        ));


        // This post validator verifies that at least one field is filled
        $this->validatorSchema->setPostvalidator(
                new sfValidatorCallback(array('callback' =>
                        array($this, 'countFilledFields')))
        );

        // Translating to spanish the fields labels
        $this->widgetSchema->setLabels(array(
                'Date'=>'Fecha',
                'Company'=>'Empresa',
                'Job'=>'Puesto',
                'Location'=>'Ubicación'
        ));

        $this->widgetSchema->setNameFormat('searchTareo[%s]');

    }

    // This post validator verifies that at least one field is filled
    public function countFilledFields($validator, $values) {

        $filled_fields_counter = 0;
        foreach ($values as $field => $value) {
            if($field!='_csrf_token') {
                //TODO: maybe is possible ask if csrf token is enabled
                if(!empty($value)) {
                    $filled_fields_counter++;
                }
            }
        }

        if($filled_fields_counter==0) {
            throw new sfValidatorError($validator,
            'Debe llenar al menos 1 campo ');
        }

        return $values;
    }


}
?>