<?php

/**
 * tareo actions.
 *
 * @package    sf_sandbox
 * @subpackage people_location
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class people_locationActions extends sfActions {
    
    /**
     * Executes index action
     *
     * @param sfRequest $request A request object
     */
    public function executeIndex(sfWebRequest $request) {

        // Creating forms
        $this->tareoForm = new TareoForm();
        $this->searchTareoForm = new SearchTareoForm();

        $this->prepareIndex($request);
    }

    /**
     * exposes some vars to template
     * @param sfWebRequest $request 
     */
    private function prepareIndex(sfWebRequest $request){
        
        
        $this->userName = $this->getUser()->getUsername();
        // Retrieving date in right format to template
        $this->date = $request->getParameter("day") != "" ?
                $request->getParameter("day") . '/'.
                $request->getParameter("month") . '/'.
                $request->getParameter("year") :
                date("d/m/Y");

        // Retrieving Tareo Table
        $this->tareoItems = Doctrine::getTable('Tareo')->findAll();
    }

    /**
     * This action is executed when createTareo form is submitted
     * This action binds and validates the form values
     * and then save a Tareo obaject.
     * @param sfWebRequest $request 
     */
    public function executeCreate(sfWebRequest $request){
        $this->tareoForm = new TareoForm();
        $this->tareoForm->bind($request->getParameter($this->tareoForm->getName()));
        if ($this->tareoForm->isValid()) {
	  $this->tareoForm->bind($request->getParameter($this->tareoForm->getName()));
            if($this->tareoForm->isValid()) {
                $this->tareoForm->save();
            }
            $this->redirect('people_location/index');
        }else{
            $this->prepareIndex($request);
            $this->searchTareoForm = new SearchTareoForm();
            $this->setTemplate('index');
        }
    }

    /**
     * This action is executed when searchTareo form is submitted
     * This action binds and validates the form values
     * @todo: and then retrieves tareo table
     * @param sfWebRequest $request
     */
    public function executeSearch(sfWebRequest $request){
        $this->searchTareoForm = new SearchTareoForm();
        $this->searchTareoForm->bind($request->getParameter($this->searchTareoForm->getName()));
        if ($this->searchTareoForm->isValid()) {
            $searchTareoFormFields = $this->searchTareoForm->getValues();
            $this->testdate = $searchTareoFormFields['Date'];
        }
        $this->prepareIndex($request);
        $this->tareoForm = new TareoForm();
        $this->setTemplate('index');
    }
}
