<?php
/*
  Class used to filter trips
 */
class ManifestSearchForm extends sfForm {
  /*
   * Configuration method
   */  
  public function configure() {
    $category_choices = array(
        '' => 'Cualquiera',
        'Aereo' => 'Aereo',
        'Fluvial' => 'Fluvial'
    );
    $this->setWidgets(array(
       'vehicle_id'     => new sfWidgetFormDoctrineChoice(array(
						      'model' => 'Vehicle', 
						      'add_empty' => 'Cualquiera',
						      )),
       'date'           => new sfWidgetFormInputText(),
       'category'       => new sfWidgetFormChoice(array('choices' => $category_choices))
    ));

    $this->setValidators(array(
      'vehicle_id'=> new sfValidatorDoctrineChoice(array('model' => 'Vehicle',
							 'required' => false)),
      'date'      => new sfValidatorString(array('max_length' => 128, 
						 'required' => false)),
      'category'  => new sfValidatorChoice(array('choices' => $category_choices, 'required' => false))
    ));
    $this->widgetSchema->setLabels(array(
        'vehicle_id' => 'Vehiculo', 
		'date' => 'Fecha',
        'category' => 'Vía'
    ));
    $this->widgetSchema->setNameFormat('manifest_search[%s]');
    $this->disableLocalCSRFProtection();
    $this->setDefault('date', date("d/m/Y"));
  }
}
?>
