<?php
/*
  Class for handling Passenger related manifest details
 */

class CustomPassengerManifestDetailForm extends sfForm {
  /*
   * Default constructor
   */
  public function __construct($options=array(), $attributes=array()) {
    $this->flight = $options['trip'];
    parent::__construct($options, $attributes);
  }

  /*
    Configuration method
   */  
  public function configure(){
    // prepare the query
    $q = Doctrine::getTable('Stretch')
      ->createQuery('v')
      ->where('trip_id = ?', $this->flight->id);


    $this->setWidgets(array(
       'id'             => new sfWidgetFormInputHidden(),
       'trip_id'        => new sfWidgetFormInputHidden(),
       'doc_number'     => new sfWidgetFormInputText(),
       'doc_type'       => new sfWidgetFormChoice(
                           array('choices' => array('DNI' => 'DNI', 
						    'CE' => 'CE', 
						    'PASAPORTE' => 'PASAPORTE',
						    'OTRO' => 'OTRO'))),
       'name'           => new sfWidgetFormInputText(),
       'company_id'     => new sfWidgetFormDoctrineChoice(
                            array('model' => 'Company', 'add_empty' => true)),
       'weight'         => new sfWidgetFormInputText(),
      'cost_center_id' => new sfWidgetFormDoctrineChoice(
			   array('model' => 'CostCenter', 'add_empty' => true)),
      'stretch_origin_id'  => new sfWidgetFormDoctrineChoice(
                                array('model' => 'Stretch', 
				      'method' => '__toOriginComboString',
				      'query'     => $q,
				      'add_empty' => true)),
      'stretch_destiny_id' => new sfWidgetFormDoctrineChoice(
                                array('model' => 'Stretch', 
				      'method' => '__toDestinationComboString',
				      'query'     => $q,
				      'add_empty' => true)),
       'delete' => new sfWidgetFormInputCheckbox(),

    ));
    $this->setValidators(array(
      'id'                 => new sfValidatorDoctrineChoice(array(
             			   'model' => 'PassengerManifestDetail', 
				   'column' => 'id', 'required' => false)),
      'trip_id'                 => new sfValidatorDoctrineChoice(array(
             			   'model' => 'Trip', 
				   'column' => 'id', 'required' => true)),

      'stretch_origin_id'  => new sfValidatorDoctrineChoice(array(
				   'model' => 'Stretch', 'required' => true)),
      'stretch_destiny_id' => new sfValidatorDoctrineChoice(array(
				   'model' => 'Stretch', 'required' => true)),
      'weight'             => new sfValidatorNumber(array('required' => true)),
      'cost_center_id'     => new sfValidatorDoctrineChoice(array(
                                   'model' => 'CostCenter', 
				   'required' => true)),
      'company_id'         => new sfValidatorDoctrineChoice(array(
				   'model' => 'Company', 'required' => true)),
      'doc_number'=> new sfValidatorDoctrineChoice(array(
                                    'model' => 'Person', 
				    'column' => 'doc_number', 
				    'required' => true)),
      'doc_type'  => new sfValidatorChoice(array('choices' => 
					     array('DNI' => 'DNI',
						   'CE' => 'CE', 
						   'PASAPORTE' => 'PASAPORTE',
						   'OTRO' => 'OTRO'),
					     'required' => true)),
      'name'      => new sfValidatorString(array('max_length' => 128, 
						 'required' => true)),
      'delete' => new sfValidatorBoolean(array('required' => false)),


    ));
    $this->widgetSchema['doc_number']->setAttribute('size', '11');
    $this->widgetSchema['weight']->setAttribute('size', '5');
    $this->widgetSchema['doc_number']->setAttribute('class', 'auto-doc-pass');

    // set the trip
    $this->setDefault('trip_id', $this->flight->id);



    $this->disableLocalCSRFProtection();
  }

  /*
   * Removes the delete checkbox
   */    
  public function unset_delete_check(){
    $this->setWidget('delete', new sfWidgetFormInputHidden());
  }

  
  /*
    Takes and object and fills the form the the object's data
    @passenger: a PassengerManifestDetail instance
   */  
  public function bind_object($passenger){
    $this->setDefault('id', $passenger->id);
    $this->setDefault('doc_number', $passenger->Person->doc_number);
    $this->setDefault('doc_type', $passenger->Person->doc_type);
    $this->setDefault('name', $passenger->Person->firstname.", ".
		      $passenger->Person->last_name);
    $this->setDefault('company_id', $passenger->Company->id);
    $this->setDefault('weight', $passenger->weight);
    $this->setDefault('cost_center_id', $passenger->CostCenter->id);
    $this->setDefault('stretch_origin_id', $passenger->Origin->id);
    $this->setDefault('stretch_destiny_id', $passenger->Destination->id);
  }

  /*
   * Changes the current form name
   * @name: the new name for the form
   */  
  public function set_name($name) {
    $this->widgetSchema->setNameFormat($name.'[%s]');
  }

  /*
   * Returns if the user provided data for this form or not
   */
  public function isFilled() {
    // the user filled this values?
    if ($this->taintedValues['doc_number'] or $this->taintedValues['name'] or
	$this->taintedValues['weight'] or $this->taintedValues['company_id'])
      return true;
    return false;
  }

  /*
   * Clears all errors in the form
   */ 
  public function clear() {
    // clear errors
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    // clear fields
    $this->resetFormFields();
  }

  /*
   * Saves the form data to the database
   */
  public function save() {
    // if delete is selected delete the element from the database
    if ($this->getValue('delete')) {
      $passenger = Doctrine::getTable('PassengerManifestDetail')
	    ->find(array($this->getValue('id')));      
      $passenger->delete();      
    }
    else {
      // if no id is provided create a new object
      $passenger = new PassengerManifestDetail();
      // if an id if provided get the element from the database for edition
      if ($this->getValue('id')) {
	$passenger = Doctrine::getTable('PassengerManifestDetail')
	  ->find(array($this->getValue('id')));      
      }
      // fill the related person
      if (!$this->getValue('doc_number')){
	    return false;
      }
      $person = Doctrine::getTable('Person')
	    ->findOneByDocNumber($this->getValue('doc_number'));
      /* Updating the weight, company and cost center in the Person table */
      $person->set('weight', $this->getValue('weight'));
      $person->set('company_id', $this->getValue('company_id'));
      $person->set('cost_center_id', $this->getValue('cost_center_id'));
      $person->save();

      $passenger->set('passenger_id', $person->id);
      $passenger->set('weight', $this->getValue('weight'));
      $passenger->set('stretch_origin_id', 
		      $this->getValue('stretch_origin_id'));
      $passenger->set('stretch_destination_id',
		      $this->getValue('stretch_destiny_id'));
      $passenger->set('cost_center_id', $this->getValue('cost_center_id'));
      $passenger->set('company_id', $this->getValue('company_id'));
      $passenger->set('trip_id', $this->getValue('trip_id'));
      $passenger->save();
      return true;
    }    
  }
}
?>
