<?php
/*
 * Class for handling Crew related manifest details
 */
class CustomCrewpersonManifestDetailForm extends sfForm{

  /*
   * Configuration method
   */  
  public function configure(){
    $this->setWidgets(array(
       'id'             => new sfWidgetFormInputHidden(),
       'trip_id'             => new sfWidgetFormInputHidden(),
       'doc_number'     => new sfWidgetFormInputText(),
       'doc_type'       => new sfWidgetFormChoice(
                           array('choices' => array('DNI' => 'DNI', 
						    'CE' => 'CE', 
						    'PASAPORTE' => 'PASAPORTE',
						    'OTRO' => 'OTRO'))),
       'name'           => new sfWidgetFormInputText(),
       'weight'         => new sfWidgetFormInputText(),
       'company_id'     => new sfWidgetFormDoctrineChoice(
                            array('model' => 'Company', 'add_empty' => true)),
       'crewposition_id'         => new sfWidgetFormDoctrineChoice(
                            array('model' => 'CrewPosition',
				  'add_empty' => true)),
       'uses_passenger_seat' => new sfWidgetFormInputCheckbox(),
       'delete' => new sfWidgetFormInputCheckbox(),
    ));

    $this->setValidators(array(
       'id'       => new sfValidatorDoctrineChoice(array(
                                    'model' => 'CrewpersonManifestDetail', 
				    'column' => 'id', 
				    'required' => false)),
      'doc_number'=> new sfValidatorDoctrineChoice(array(
                                    'model' => 'Person', 
				    'column' => 'doc_number', 
				    'required' => true)),
      'doc_type'  => new sfValidatorChoice(array('choices' => 
					     array('DNI' => 'DNI',
						   'CE' => 'CE', 
						   'PASAPORTE' => 'PASAPORTE',
						   'OTRO' => 'OTRO'),
					     'required' => true)),
      'name'      => new sfValidatorString(array('max_length' => 128, 
						 'required' => true)),
      'weight'    => new sfValidatorNumber(array('required' => true)),
      'company_id'=> new sfValidatorDoctrineChoice(array('model' => 'Company',
							 'required' => true)),
      'trip_id'=> new sfValidatorDoctrineChoice(array(
                                    'model' => 'Trip', 
				    'column' => 'id', 
				    'required' => true)),


      'crewposition_id'    => new sfValidatorDoctrineChoice(array(
						'model' => 'CrewPosition',
						'required' => true)),      
      'uses_passenger_seat' => new sfValidatorBoolean(array(
						      'required' => false)),
      'delete' => new sfValidatorBoolean(array('required' => false)),


    ));

    $this->disableLocalCSRFProtection();
    $this->widgetSchema['doc_number']->setAttribute('class', 'auto-doc');

  }
  /*
   * Removes the delete checkbox
   */    
  public function unset_delete_check(){
    $this->setWidget('delete', new sfWidgetFormInputHidden());
  }
  /*
   * Takes and object and fills the form the the object's data
   * @crew: a CrewpersonManifestDetail instance
   */  
  public function bind_object($crew){
    $this->setDefault('id', $crew->id);
    $this->setDefault('trip_id', $crew->Trip->id);
    $this->setDefault('weight', $crew->weight);
    $this->setDefault('company_id', $crew->Company->id);
    $this->setDefault('name', $crew->Person->last_name.", ".
		      $crew->Person->firstname);
    $this->setDefault('doc_number', $crew->Person->doc_number);
    $this->setDefault('doc_type', $crew->Person->doc_type);
    $this->setDefault('crewposition_id', $crew->CrewPosition->id);
    $this->setDefault('uses_passenger_seat', $crew->uses_passenger_seat);
  }
  

  /*
   * Changes the current form name
   * @name: the new name for the form
   */  
  public function set_name($name) {
    $this->widgetSchema->setNameFormat($name.'[%s]');
  }

  /*
   * Returns if the user provided data for this form or not, this just works 
   * when for form is not valid, otherwise we don't need it
   */
  public function isFilled() {
    // the user filled this values?
    if ($this->taintedValues['doc_number'] or $this->taintedValues['name'] or
	$this->taintedValues['weight'] or $this->taintedValues['id'] or
	$this->taintedValues['company_id'])
      return true;
    return false;
  }

  /*
   * Clears all errors in the form
   */
  public function clear() {
    // clear errors
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    // clear fields
    $this->resetFormFields();
  }

  /*
   * Saves data to the database
   */
  public function save() {
    // if delete is selected delete the element from the database
    if ($this->getValue('delete')) {
      $crew = Doctrine::getTable('CrewpersonManifestDetail')
	->find(array($this->getValue('id')));      
      $crew->delete();      
    }
    else {
      // if no id is provided create a new object
      $crew = new CrewpersonManifestDetail();
      // if an id if provided get the element from the database for edition
      if ($this->getValue('id')) {
	$crew = Doctrine::getTable('CrewpersonManifestDetail')
	  ->find(array($this->getValue('id')));      
      }
      // fill the elements in the object and save it
      $crew->uses_passenger_seat = $this->getValue('uses_passenger_seat');
      $crew->weight = $this->getValue('weight');
      
      $crew->set('trip_id', $this->getValue('trip_id'));
      // get the selected person and update its values
      if (!$this->getValue('doc_number')){
	return false;
      }
      $person = Doctrine::getTable('Person')
	->findOneByDocNumber($this->getValue('doc_number'));
      $person->set('weight', $this->getValue('weight'));
      $person->set('company_id', $this->getValue('company_id'));
      $person->save();

      $crew->set('crewperson_id', $person->id);
      $crew->set('crew_position_id', $this->getValue('crewposition_id'));      
      $crew->set('company_id', $this->getValue('company_id'));
      $crew->save();
      return true;
 
    }

  }
}
?>