<?php
/*
 *  Form used to create Cargo Manifest Details in Formsets
 */
class CustomCargoManifestDetailForm extends sfForm{
  var $flight;

  /*
   * Default constructor
   */
  public function __construct($options=array(), $attributes=array()) {
    $this->flight = $options['trip'];
    parent::__construct($options, $attributes);
  }
  
  /*
   * Configuration method
   */  
  public function configure() {
   
    // prepare the query
    $q = Doctrine::getTable('Stretch')
      ->createQuery('v')
      ->where('trip_id = ?', $this->flight->id);
    // set widgets
    $this->setWidgets(array(
      'id'                 => new sfWidgetFormInputHidden(),
      'trip_id'                 => new sfWidgetFormInputHidden(),
      'stretch_origin_id'  => new sfWidgetFormDoctrineChoice(array(
			       'model'     => 'Stretch',
			       'method'    => '__toOriginComboString',
			       'query'     => $q,
			       'add_empty' => true)),
      'stretch_destiny_id' => new sfWidgetFormDoctrineChoice(array(
                               'model' => 'Stretch',
			       'method' => '__toDestinationComboString',
			       'query'     => $q,
			       'add_empty' => true)),
      'description'        => new sfWidgetFormInputText(),
      'weight'             => new sfWidgetFormInputText(),
      'cost_center_id'     => new sfWidgetFormDoctrineChoice(array(
			    'model' => 'CostCenter',
			    'add_empty' => true)),
      'company_id'         => new sfWidgetFormDoctrineChoice(array(
			    'model' => 'Company', 
			    'add_empty' => true)),
       'delete' => new sfWidgetFormInputCheckbox(),

    ));

    // set the validators
    $this->setValidators(array(
       'id'                 => new sfValidatorDoctrineChoice(
				   array('model' => 'CargoManifestDetail', 
					 'column' => 'id', 
					 'required' => false)),
       'trip_id'                 => new sfValidatorDoctrineChoice(
				   array('model' => 'Trip', 
					 'column' => 'id', 
					 'required' => true)),
      'stretch_origin_id'  => new sfValidatorDoctrineChoice(
                                   array('model' => 'Stretch', 
					 'required' => true)),
      'stretch_destiny_id' => new sfValidatorDoctrineChoice(
                                   array('model' => 'Stretch', 
					 'required' => true)),
      'description'        => new sfValidatorString(array('max_length' => 200,
							  'required' => true)),
      'weight'             => new sfValidatorNumber(array('required' => true)),
      'cost_center_id'     => new sfValidatorDoctrineChoice(
				   array('model' => 'CostCenter', 
					 'required' => true)),
      'company_id'         => new sfValidatorDoctrineChoice(
				   array('model' => 'Company', 
					 'required' => true)),
      'delete'         =>  new sfValidatorBoolean(array('required' => false)),
    ));
    $this->widgetSchema['weight']->setAttribute('size', '5');

    // set the trip
    $this->setDefault('trip_id', $this->flight->id);

    $this->disableLocalCSRFProtection();

  }

  /*
   * Removes the delete checkbox
   */    
  public function unset_delete_check(){
    $this->setWidget('delete', new sfWidgetFormInputHidden());
  }

  /*
   * Changes the current form name
   * @name: the new name for the form
   */  
  public function set_name($name) {
    $this->widgetSchema->setNameFormat($name.'[%s]');
  }

  /*
   * Returns if the user provided data for this form or not, this just works 
   * when for form is not valid, otherwise we don't need it
   */
  public function isFilled() {
    // the user filled this values?
    if ($this->taintedValues['description'] or $this->taintedValues['weight']
	or $this->taintedValues['company_id']) {
      return true;      
    }
    return false;
  }

  public function clear(){
    // clear errors
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    // clear fields
    $this->resetFormFields();
  }

  /*
   * Takes and object and fills the form the the object's data
   * @crew: a CrewpersonManifestDetail instance
   */  
  public function bind_object($cargo){
    $this->setDefault('id', $cargo->id);
    $this->setDefault('stretch_origin_id', $cargo->Origin->id);
    $this->setDefault('stretch_destiny_id', $cargo->Destination->id);
    $this->setDefault('description', $cargo->description);
    $this->setDefault('weight', $cargo->weight);
    $this->setDefault('company_id', $cargo->Company->id);
    $this->setDefault('cost_center_id', $cargo->CostCenter->id); 
  }

  public function save(){
    if (!$this->isFilled()){
      return false;
    }
    // if delete is selected delete the element from the database
    if ($this->getValue('delete')) {
      $cargo = Doctrine::getTable('CargoManifestDetail')
	->find(array($this->getValue('id')));      
      $cargo->delete();      
    }
    else {
      // if no id is provided create a new object
      $cargo = new CargoManifestDetail();
      // if an id if provided get the element from the database for edition
      if ($this->getValue('id')) {
	$cargo = Doctrine::getTable('CargoManifestDetail')
	  ->find(array($this->getValue('id')));      
      }
      // fill the elements in the object and save it
      $cargo->description = $this->getValue('description');
      $cargo->weight = $this->getValue('weight');
      $cargo->set('stretch_origin_id', $this->getValue('stretch_origin_id'));
      $cargo->set('stretch_destination_id', 
		  $this->getValue('stretch_destiny_id'));
      $cargo->set('cost_center_id', $this->getValue('cost_center_id'));
      $cargo->set('company_id', $this->getValue('company_id'));
      $cargo->set('trip_id', $this->getValue('trip_id'));

      $cargo->save();
      return true;
    }
    
  }
}
?>