<?php
/*
  Class used to dinamically create CargoForms
 */
class CargoFormSet {
  var $flight;
  var $max_forms;
  var $forms;
  var $form_count;

  /*
    Default contructor
    @flight: the flight (Trip) related to the cargo set
    @max_forms: maximum ammount of forms used with out considering the 
        details in the database
    @name: the name for the forms
  */
  public function __construct($flight,  $max_forms, $name) {
     $this->flight = $flight;
     $this->max_forms = $max_forms;
     // get the related cargos
     $cargos = Doctrine_Query::create()
       ->select('c.*')
       ->from('CargoManifestDetail c')
       ->leftJoin('c.Origin o')
       ->where('o.trip_id = ?', $flight->id)
       ->execute();
     $saved_cargos = count($cargos); 
     // prepare pre filled forms
     $i = 0;
     foreach ($cargos as $cargo) {
       $this->forms[$i] = new CustomCargoManifestDetailForm(
                                                        array('trip'=>$flight));
       $this->forms[$i]->bind_object($cargo);
       $this->forms[$i]->set_name($name."_formset#".$i);
       $i++;
     }
     if ($saved_cargos > $max_forms){
       $max_forms = $saved_cargos + 5;
     }


     // append empty forms
     for ($i = $saved_cargos; $i < $max_forms ; $i++) {
       $this->forms[$i] = new CustomCargoManifestDetailForm(
                                                        array('trip'=>$flight));
       $this->forms[$i]->set_name($name."_formset#".$i);
       $this->forms[$i]->unset_delete_check();
     }
     $this->form_count = $max_forms;
    
   }

  /*
   * Fills the formset with data from the request
   * @request: the WebRequest object provided by Symfony
   */  
  function bind(sfWebRequest $request) {
    // bind every form in the set
    foreach ($this->forms as $form) {
      $form->bind($request->getParameter($form->getName()),
		  $request->getFiles($form->getName()));
    }
  }

  /*
   * Validates every form in the set
   */
  public function is_valid() {
    $has_errors = false;
    foreach ($this->forms as $form) {
      // if the form is not valid and not filled this is not an error
      if(!$form->isValid()) {
	if (!$form->isFilled()) {
	// the form is empty so clean the errors and fields
	$form->clear();
	}
	else {
	  $has_errors = true;
	}
      }
    }
    return !$has_errors;
  }

  /*
   * saves every form in the set
   */
  public function save() {
    foreach ($this->forms as $form) {
      $form->save();
    }
  }

}
?>
