<?php

/**
 * location actions.
 *
 * @package    PLM
 * @subpackage location
 * @author     Aureal_Systems
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class locationActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->locations = Doctrine::getTable('Location')
      ->createQuery('a')
      ->execute();
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->form = new LocationForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();

    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new LocationForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($location = Doctrine::getTable('Location')->find(array($request->getParameter('id'))), sprintf('Object location does not exist (%s).', $request->getParameter('id')));

    /*  The object needs to be passed to the template for displaying the ID and any other attribute */
    $this->location = $location;

    $this->form = new LocationForm($location);
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($location = Doctrine::getTable('Location')->find(array($request->getParameter('id'))), sprintf('Object location does not exist (%s).', $request->getParameter('id')));
    $this->form = new LocationForm($location);

    $this->processForm($request, $this->form);

    /*  The object needs to be passed to the template for displaying the ID and any other attribute */
    $this->location = $location;

    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $request->checkCSRFProtection();

    $this->forward404Unless($location = Doctrine::getTable('Location')->find(array($request->getParameter('id'))), sprintf('Object location does not exist (%s).', $request->getParameter('id')));
    $location->delete();

    $this->redirect('@location');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
        $location = $form->save();
        $this->redirect('@location');
    }
  }
}
