<?php use_javascript('ui.core.js') ?>
<?php use_stylesheet('ui-lightness/jquery-ui-1.8rc1.custom.css') ?>

<?php slot('username',$username); ?>
<?php slot('breadCrumbs',Helper::makeBreadCrumbs(array(
    array('text' => 'Distancias')
))); ?>

<style type="text/css">td.td-right{text-align: right}</style>

<div id="main">
<h2>Distancias</h2>
<form style="float: left;">
  <ul class="vertical_form">
    <li>
    <table class="data" border="1" cellspacing="0" cellpadding="0">
      <thead>
        <tr>
          <th>Id</th>
          <th>Origen</th>
          <th>Destino</th>
          <th>Distancia (Km)</th>
          <th>Creación</th>
          <th>Edición</th>
          <th>Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php $odd = true; ?>
        <?php foreach ($distances as $distance) { ?>
        <tr<?php if ($odd) { ?> class="odd"<?php } ?>>
          <td><?php echo $distance->getId() ?></td>
          <td><?php echo $distance->getOrigin() ?></td>
          <td><?php echo $distance->getDestination() ?></td>
          <td class="td-right"><?php echo $distance->getDistance() ?></td>
          <td><?php echo $distance->getCreatedAt() ?></td>
          <td><?php echo $distance->getUpdatedAt() ?></td>
          <td>
          <?php echo link_to('Editar', 'distance/edit?id='.$distance->getId()); ?>
          <?php echo link_to('Eliminar', 'distance/delete?id='.$distance->getId(), array('method' => 'delete', 'confirm' => '¿Está seguro?')); ?>
          </td>
        </tr>
        <?php $odd = !$odd; ?>
        <?php } ?>
      </tbody>
    </table>
    </li>
    <li><a href="<?php echo url_for('@distance_new') ?>">Nueva</a></li>
    </ul>
    </form>
</div>
