<?php

/**
 * distance actions.
 *
 * @package    PLM
 * @subpackage distance
 * @author     Aureal_Systems
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */

class distanceActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {

    $this->username = $this->getUser()->getUsername();
    $this->distances = Doctrine::getTable('Distance')
      ->createQuery('a')
      ->execute();
  }

  public function executeNew(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->form = new DistanceForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();

    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new DistanceForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($distance = Doctrine::getTable('Distance')->find(array($request->getParameter('id'))), sprintf('Object distance does not exist (%s).', $request->getParameter('id')));
    $this->distance = $distance;
    $this->form = new DistanceForm($distance);
  }

  public function executeUpdate(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($distance = Doctrine::getTable('Distance')->find(array($request->getParameter('id'))), sprintf('Object distance does not exist (%s).', $request->getParameter('id')));
    $this->form = new DistanceForm($distance);
    $this->processForm($request, $this->form);
    $this->distance = $distance;
    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $request->checkCSRFProtection();

    $this->forward404Unless($distance = Doctrine::getTable('Distance')->find(array($request->getParameter('id'))), sprintf('Object distance does not exist (%s).', $request->getParameter('id')));
    $distance->delete();

    $this->redirect('@distance');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $distance = $form->save();
      $this->redirect('@distance');
    }
  }

  public function executeLookup(sfWebRequest $request)
  {

      $result = array();

      /* Default values */
      $result['success'] = FALSE;
      $result['exists'] = FALSE;
      $result['value'] = '';

      $origin_id = $request->getParameter('origin', '');
      $destination_id = $request->getParameter('destination', '');

      if (strlen($origin_id)>0 && strlen($destination_id)>0) {
          $result['success'] = TRUE;
          $value = DistanceTable::getDistance($origin_id, $destination_id);
          if ($value) {
              $result['exists'] = TRUE;
              $result['value'] = $value;
          } else {
              $result['exists'] = FALSE;
          }
      }

      // for production use 
      $this->getResponse()->setHttpHeader('Content-type', 'application/json');
      // for debuggin use
      //$this->getResponse()->setHttpHeader('Content-type', 'text/plain');

      $result = json_encode($result);
      return $this->renderText($result);
  }

}

?>
