<?php

/**
 * cost_center actions.
 *
 * @package    PLM
 * @subpackage cost_center
 * @author     Aureal_Systems
 * @version    SVN: $Id: actions.class.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class cost_centerActions extends sfActions
{
  public function executeIndex(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();
    $this->cost_centers = Doctrine::getTable('CostCenter')
      ->createQuery('a')
      ->execute();
  }

  public function executeNew(sfWebRequest $request)
  {    
    $this->username = $this->getUser()->getUsername();
    $this->form = new CostCenterForm();
  }

  public function executeCreate(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();

    $this->forward404Unless($request->isMethod(sfRequest::POST));

    $this->form = new CostCenterForm();

    $this->processForm($request, $this->form);

    $this->setTemplate('new');
  }

  public function executeEdit(sfWebRequest $request)
 {
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($cost_center = Doctrine::getTable('CostCenter')->find(array($request->getParameter('id'))), sprintf('Object cost_center does not exist (%s).', $request->getParameter('id')));
    $this->form = new CostCenterForm($cost_center);
    $this->cost_center = $cost_center;
  }

  public function executeUpdate(sfWebRequest $request)
  { 
    $this->username = $this->getUser()->getUsername();
    $this->forward404Unless($request->isMethod(sfRequest::POST) || $request->isMethod(sfRequest::PUT));
    $this->forward404Unless($cost_center = Doctrine::getTable('CostCenter')->find(array($request->getParameter('id'))), sprintf('Object cost_center does not exist (%s).', $request->getParameter('id')));
    $this->form = new CostCenterForm($cost_center);

    $this->processForm($request, $this->form);
    $this->cost_center = $cost_center;
    $this->setTemplate('edit');
  }

  public function executeDelete(sfWebRequest $request)
  {
    $this->username = $this->getUser()->getUsername();

    $request->checkCSRFProtection();

    $this->forward404Unless($cost_center = Doctrine::getTable('CostCenter')->find(array($request->getParameter('id'))), sprintf('Object cost_center does not exist (%s).', $request->getParameter('id')));
    $cost_center->delete();

    $this->redirect('@cost_center');
  }

  protected function processForm(sfWebRequest $request, sfForm $form)
  {
    $form->bind($request->getParameter($form->getName()), $request->getFiles($form->getName()));
    if ($form->isValid())
    {
      $cost_center = $form->save();
      $this->redirect('@cost_center');
    }
  }
}
